/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ThreadStopSuspendResumeInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("CallToThreadStopSuspendOrResumeManager" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ThreadStopSuspendResumeInspection.getID must not return null");
        }
        return "CallToThreadStopSuspendOrResumeManager";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("thread.stop.suspend.resume.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ThreadStopSuspendResumeInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("thread.stop.suspend.resume.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/ThreadStopSuspendResumeInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadStopSuspendVisitor();
    }

    private static class ThreadStopSuspendVisitor
    extends BaseInspectionVisitor {
        private ThreadStopSuspendVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/threading/ThreadStopSuspendResumeInspection$ThreadStopSuspendVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!ThreadStopSuspendVisitor.isStopSuspendOrResume(expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean isStopSuspendOrResume(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!("stop".equals(methodName) || "suspend".equals(methodName) || "resume".equals(methodName))) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String className = aClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            return "java.lang.Thread".equals(className);
        }
    }
}

