/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importWizard;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseXml;

public class EclipseProjectFinder
implements EclipseXml {
    public static void findModuleRoots(List<String> paths, String rootPath) {
        String project;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            if (progressIndicator.isCanceled()) {
                return;
            }
            progressIndicator.setText2(rootPath);
        }
        if ((project = EclipseProjectFinder.findProjectName(rootPath)) != null) {
            paths.add(rootPath);
        } else {
            File[] files;
            File root = new File(rootPath);
            if (root.isDirectory() && (files = root.listFiles()) != null) {
                for (File file : files) {
                    EclipseProjectFinder.findModuleRoots(paths, file.getPath());
                }
            }
        }
    }

    @Nullable
    public static String findProjectName(String rootPath) {
        String name = null;
        File file = new File(rootPath, ".project");
        if (file.isFile()) {
            try {
                name = JDOMUtil.loadDocument((File)file).getRootElement().getChildText("name");
            }
            catch (JDOMException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return name;
    }

    public static boolean isExternalResource(@NotNull String projectPath, @NotNull String relativePath) {
        if (projectPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/eclipse/importWizard/EclipseProjectFinder.isExternalResource must not be null");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/idea/eclipse/importWizard/EclipseProjectFinder.isExternalResource must not be null");
        }
        String independentPath = EclipseProjectFinder.extractPathVariableName(relativePath);
        File file = new File(projectPath, ".project");
        if (file.isFile()) {
            try {
                for (Object o : JDOMUtil.loadDocument((File)file).getRootElement().getChildren("linkedResources")) {
                    for (Object l : ((Element)o).getChildren("link")) {
                        if (!Comparing.strEqual((String)((Element)l).getChildText("name"), (String)independentPath)) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String extractPathVariableName(String relativePath) {
        String independentPath = FileUtil.toSystemIndependentName((String)relativePath);
        int idx = independentPath.indexOf(47);
        if (idx != -1) {
            independentPath = independentPath.substring(0, idx);
        }
        return independentPath;
    }
}

