/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.util;

import com.intellij.openapi.util.io.FileUtil;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.eclipse.conversion.ConversionException;

public class ErrorLog {
    public static boolean failFast = true;
    public static Impl defaultImpl;

    public static void release() {
        defaultImpl = null;
    }

    public static void report(Level level, @NonNls String module, @NonNls String context, @NonNls String message) {
        if (defaultImpl != null) {
            defaultImpl.report(level, module, context, message);
        }
    }

    public static void rethrow(Level level, @NonNls String module, @NonNls String context, Exception e) throws IOException, ConversionException {
        ErrorLog.report(level, module, context, e);
        if (failFast) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ConversionException) {
                throw (ConversionException)e;
            }
            throw new ConversionException(e.getMessage());
        }
    }

    public static void report(Level level, @NonNls String module, @NonNls String context, Exception e) {
        String message = e.getMessage();
        ErrorLog.report(level, module, context, message == null ? e.getClass().toString() : FileUtil.toSystemIndependentName((String)message));
    }

    public static interface Impl {
        public void report(Level var1, @NonNls String var2, @NonNls String var3, @NonNls String var4);
    }

    public static enum Level {
        Warning,
        Error,
        Fatal;

    }
}

