/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class GitReference
implements Comparable<GitReference> {
    protected final String myName;

    public GitReference(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/GitReference.<init> must not be null");
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/GitReference.getName must not return null");
        }
        return string;
    }

    @NotNull
    public abstract String getFullName();

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object obj) {
        return obj instanceof GitReference && this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(GitReference o) {
        return o == null ? 1 : this.getFullName().compareTo(o.getFullName());
    }

    public static Set<String> getNameClashes(Collection<? extends GitReference> ... collections) {
        ArrayList individual = new ArrayList();
        for (Collection<? extends GitReference> c : collections) {
            HashSet<String> s = new HashSet<String>();
            individual.add(s);
            for (GitReference gitReference : c) {
                s.add(gitReference.getName());
            }
        }
        HashSet<String> rc = new HashSet<String>();
        for (int i = 0; i < collections.length - 1; ++i) {
            HashSet si = (HashSet)individual.get(i);
            for (int j = i + 1; j < collections.length; ++j) {
                HashSet sj = (HashSet)individual.get(i);
                HashSet copy = new HashSet(si);
                copy.retainAll(sj);
                rc.addAll(copy);
            }
        }
        return rc;
    }
}

