/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseActionDialog;
import git4idea.rebase.GitRebaseUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitRebaseAbort
extends GitRepositoryAction {
    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        VirtualFile root;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/actions/GitRebaseAbort.perform must not be null");
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of git4idea/actions/GitRebaseAbort.perform must not be null");
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/actions/GitRebaseAbort.perform must not be null");
        }
        Iterator<VirtualFile> i = gitRoots.iterator();
        while (i.hasNext()) {
            if (GitRebaseUtils.isRebaseInTheProgress(i.next())) continue;
            i.remove();
        }
        if (gitRoots.size() == 0) {
            Messages.showErrorDialog((Project)project, (String)GitBundle.getString("rebase.action.no.root"), (String)GitBundle.getString("rebase.action.error"));
            return;
        }
        if (gitRoots.size() == 1) {
            root = gitRoots.get(0);
        } else {
            GitRebaseActionDialog d;
            if (!gitRoots.contains(defaultRoot)) {
                defaultRoot = gitRoots.get(0);
            }
            if ((root = (d = new GitRebaseActionDialog(project, this.getActionName(), gitRoots, defaultRoot)).selectRoot()) == null) {
                return;
            }
        }
        affectedRoots.add(root);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.REBASE);
        h.addParameters("--abort");
        GitHandlerUtil.doSynchronously(h, this.getActionName(), h.printableCommandLine());
    }

    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("rebase.abort.action.name");
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/actions/GitRebaseAbort.getActionName must not return null");
        }
        return string;
    }
}

