/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.equality;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class ObjectEqualityPredicate
implements PsiElementPredicate {
    ObjectEqualityPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiClassType lhsClassType;
        PsiClass lhsClass;
        PsiClassType rhsClassType;
        PsiClass rhsClass;
        if (!(element instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)element;
        PsiJavaToken sign = expression.getOperationSign();
        IElementType tokenType = sign.getTokenType();
        if (!tokenType.equals(JavaTokenType.NE) && !tokenType.equals(JavaTokenType.EQEQ)) {
            return false;
        }
        PsiExpression lhs = expression.getLOperand();
        String lhsText = lhs.getText();
        if ("null".equals(lhsText)) {
            return false;
        }
        PsiType lhsType = lhs.getType();
        if (lhsType == null) {
            return false;
        }
        PsiExpression rhs = expression.getROperand();
        if (rhs == null) {
            return false;
        }
        String rhsText = rhs.getText();
        if ("null".equals(rhsText)) {
            return false;
        }
        PsiType rhsType = rhs.getType();
        if (rhsType == null) {
            return false;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lhsType) || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rhsType)) {
            return false;
        }
        if (rhsType instanceof PsiClassType && (rhsClass = (rhsClassType = (PsiClassType)rhsType).resolve()) != null && rhsClass.isEnum()) {
            return false;
        }
        if (lhsType instanceof PsiClassType && (lhsClass = (lhsClassType = (PsiClassType)lhsType).resolve()) != null && lhsClass.isEnum()) {
            return false;
        }
        return !ErrorUtil.containsError(element);
    }
}

