/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class HighlightUtil {
    public static void highlightElements(@NotNull Collection<? extends PsiElement> elementCollection) {
        if (elementCollection == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ipp/psiutils/HighlightUtil.highlightElements must not be null");
        }
        if (elementCollection.isEmpty()) {
            return;
        }
        PsiElement[] elements = elementCollection.toArray(new PsiElement[elementCollection.size()]);
        Project project = elements[0].getProject();
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Editor editor = editorManager.getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        EditorColorsScheme globalScheme = editorColorsManager.getGlobalScheme();
        TextAttributes textattributes = globalScheme.getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        highlightManager.addOccurrenceHighlights(editor, elements, textattributes, true, null);
        FindManager findmanager = FindManager.getInstance((Project)project);
        FindModel findmodel = findmanager.getFindNextModel();
        if (findmodel == null) {
            findmodel = findmanager.getFindInFileModel();
        }
        findmodel.setSearchHighlighters(true);
        findmanager.setFindWasPerformed();
        findmanager.setFindNextModel(findmodel);
    }
}

