/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.SshLogger;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.cvsclient.connection.ConnectionSettings;

public class SocksAuthenticatorManager {
    private static final String SOCKS_REQUESTING_PROTOCOL = "SOCKS";
    private final MyAuthenticator myAuthenticator = new MyAuthenticator();
    private volatile boolean myIsRegistered;
    private final Object myLock = new Object();

    public static SocksAuthenticatorManager getInstance() {
        return (SocksAuthenticatorManager)ServiceManager.getService(SocksAuthenticatorManager.class);
    }

    private SocksAuthenticatorManager() {
    }

    public void register(ConnectionSettings connectionSettings) {
        SshLogger.debug("register in authenticator");
        this.ensureRegistered();
        this.myAuthenticator.register(connectionSettings.getProxyHostName(), connectionSettings.getProxyPort(), connectionSettings.getProxyLogin(), connectionSettings.getProxyPassword());
    }

    public void unregister(ConnectionSettings connectionSettings) {
        SshLogger.debug("unregister in authenticator");
        this.myAuthenticator.unregister(connectionSettings.getProxyHostName(), connectionSettings.getProxyPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRegistered() {
        if (!this.myIsRegistered) {
            Object object = this.myLock;
            synchronized (object) {
                if (!this.myIsRegistered) {
                    this.myIsRegistered = true;
                    Authenticator.setDefault(this.myAuthenticator);
                }
            }
        }
    }

    private static class MyAuthenticator
    extends Authenticator {
        private final Map<Pair<String, Integer>, Pair<String, String>> myKnown = Collections.synchronizedMap(new HashMap());

        private MyAuthenticator() {
        }

        public void register(String host, int port, String login, String password) {
            this.myKnown.put((Pair<String, Integer>)new Pair((Object)host, (Object)port), (Pair<String, String>)new Pair((Object)login, (Object)password));
        }

        public void unregister(String host, int port) {
            this.myKnown.remove(new Pair((Object)host, (Object)port));
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            int port;
            SshLogger.debug("proxy authenticator asked");
            String protocol = this.getRequestingProtocol();
            if (protocol == null || !StringUtil.containsIgnoreCase((String)protocol, (String)SocksAuthenticatorManager.SOCKS_REQUESTING_PROTOCOL)) {
                return super.getPasswordAuthentication();
            }
            Authenticator.RequestorType type = this.getRequestorType();
            String host = this.getRequestingHost();
            Pair<String, String> result = this.myKnown.get(new Pair((Object)host, (Object)(port = this.getRequestingPort())));
            if (result != null) {
                SshLogger.debug("proxy authenticator found what to answer");
                return new PasswordAuthentication((String)result.getFirst(), ((String)result.getSecond()).toCharArray());
            }
            return super.getPasswordAuthentication();
        }
    }
}

