/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.SortingException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingOrder {
    @NonNls
    private static final String FIRST_STR = "FIRST";
    @NonNls
    private static final String LAST_STR = "LAST";
    @NonNls
    private static final String BEFORE_STR = "BEFORE ";
    @NonNls
    private static final String BEFORE_STR_OLD = "BEFORE:";
    @NonNls
    private static final String AFTER_STR = "AFTER ";
    @NonNls
    private static final String AFTER_STR_OLD = "AFTER:";
    public static final LoadingOrder ANY = new LoadingOrder();
    public static final LoadingOrder FIRST = new LoadingOrder("FIRST");
    public static final LoadingOrder LAST = new LoadingOrder("LAST");
    @NonNls
    private final String myName;
    private final boolean myFirst;
    private final boolean myLast;
    private final Set<String> myBefore;
    private final Set<String> myAfter;

    private LoadingOrder() {
        this.myBefore = new HashSet<String>();
        this.myAfter = new HashSet<String>();
        this.myName = "ANY";
        this.myFirst = false;
        this.myLast = false;
    }

    private LoadingOrder(@NonNls @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/extensions/LoadingOrder.<init> must not be null");
        }
        this.myBefore = new HashSet<String>();
        this.myAfter = new HashSet<String>();
        this.myName = text;
        boolean last = false;
        boolean first = false;
        for (String string : StringUtil.split((String)text, (String)",")) {
            String trimmed = string.trim();
            if (trimmed.equalsIgnoreCase(FIRST_STR)) {
                first = true;
                continue;
            }
            if (trimmed.equalsIgnoreCase(LAST_STR)) {
                last = true;
                continue;
            }
            if (StringUtil.startsWithIgnoreCase((String)trimmed, (String)BEFORE_STR)) {
                this.myBefore.add(trimmed.substring(BEFORE_STR.length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase((String)trimmed, (String)BEFORE_STR_OLD)) {
                this.myBefore.add(trimmed.substring(BEFORE_STR_OLD.length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase((String)trimmed, (String)AFTER_STR)) {
                this.myAfter.add(trimmed.substring(AFTER_STR.length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase((String)trimmed, (String)AFTER_STR_OLD)) {
                this.myAfter.add(trimmed.substring(AFTER_STR_OLD.length()).trim());
                continue;
            }
            throw new AssertionError((Object)("Invalid specification: " + trimmed + "; should be one of FIRST, LAST, BEFORE <id> or AFTER <id>"));
        }
        this.myFirst = first;
        this.myLast = last;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadingOrder)) {
            return false;
        }
        LoadingOrder that = (LoadingOrder)o;
        if (this.myFirst != that.myFirst) {
            return false;
        }
        if (this.myLast != that.myLast) {
            return false;
        }
        if (!((Object)this.myAfter).equals(that.myAfter)) {
            return false;
        }
        return ((Object)this.myBefore).equals(that.myBefore);
    }

    public int hashCode() {
        int result = this.myFirst ? 1 : 0;
        result = 31 * result + (this.myLast ? 1 : 0);
        result = 31 * result + ((Object)this.myBefore).hashCode();
        result = 31 * result + ((Object)this.myAfter).hashCode();
        return result;
    }

    public static LoadingOrder before(@NonNls String id) {
        return new LoadingOrder(BEFORE_STR + id);
    }

    public static LoadingOrder after(@NonNls String id) {
        return new LoadingOrder(AFTER_STR + id);
    }

    public static void sort(final Orderable[] orderables) {
        final HashMap<String, Orderable> map = new HashMap<String, Orderable>();
        for (Orderable orderable : orderables) {
            String id = orderable.getOrderId();
            if (!StringUtil.isNotEmpty((String)id)) continue;
            map.put(id, orderable);
        }
        DFSTBuilder builder = new DFSTBuilder((Graph)new GraphGenerator((GraphGenerator.SemiGraph)new CachingSemiGraph((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Orderable>(){

            public Collection<Orderable> getNodes() {
                ArrayList<Orderable> list = new ArrayList<Orderable>(Arrays.asList(orderables));
                Collections.reverse(list);
                return list;
            }

            public Iterator<Orderable> getIn(Orderable n) {
                LoadingOrder order = n.getOrder();
                LinkedHashSet<Orderable> predecessors = new LinkedHashSet<Orderable>();
                for (String id : order.myAfter) {
                    Orderable orderable = (Orderable)map.get(id);
                    if (orderable == null) continue;
                    predecessors.add(orderable);
                }
                String id = n.getOrderId();
                for (Orderable orderable : orderables) {
                    LoadingOrder hisOrder = orderable.getOrder();
                    if (!(StringUtil.isNotEmpty((String)id) && hisOrder.myBefore.contains(id) || order.myLast && !hisOrder.myLast) && (!hisOrder.myFirst || order.myFirst)) continue;
                    predecessors.add(orderable);
                }
                return predecessors.iterator();
            }
        })));
        if (!builder.isAcyclic()) {
            Pair dependency = builder.getCircularDependency();
            throw new SortingException("Could not satisfy sorting requirements", new Element[]{((Orderable)dependency.first).getDescribingElement(), ((Orderable)dependency.second).getDescribingElement()});
        }
        Arrays.sort(orderables, builder.comparator());
    }

    public static LoadingOrder readOrder(@NonNls String orderAttr) {
        return orderAttr != null ? new LoadingOrder(orderAttr) : ANY;
    }

    public static interface Orderable {
        @Nullable
        public String getOrderId();

        public LoadingOrder getOrder();

        public Element getDescribingElement();
    }
}

