/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.StringDescriptorManager;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.core.SupportCode;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.inspections.AssignMnemonicFix;
import com.intellij.uiDesigner.inspections.BaseFormInspection;
import com.intellij.uiDesigner.inspections.EditorQuickFixProvider;
import com.intellij.uiDesigner.inspections.FormErrorCollector;
import com.intellij.uiDesigner.inspections.FormInspectionUtil;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateMnemonicInspection
extends BaseFormInspection {
    private static final ThreadLocal<HashMap<IRootContainer, MnemonicMap>> myContainerMnemonicMap = new ThreadLocal<HashMap<IRootContainer, MnemonicMap>>(){

        @Override
        protected HashMap<IRootContainer, MnemonicMap> initialValue() {
            return new HashMap<IRootContainer, MnemonicMap>();
        }
    };

    public DuplicateMnemonicInspection() {
        super("DuplicateMnemonic");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = UIDesignerBundle.message("inspection.duplicate.mnemonics", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/inspections/DuplicateMnemonicInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    public void startCheckForm(IRootContainer radRootContainer) {
        myContainerMnemonicMap.get().put(radRootContainer, new MnemonicMap());
    }

    @Override
    public void doneCheckForm(IRootContainer rootContainer) {
        myContainerMnemonicMap.get().remove(rootContainer);
    }

    @Override
    protected void checkComponentProperties(Module module, IComponent component, FormErrorCollector collector) {
        SupportCode.TextWithMnemonic twm = DuplicateMnemonicInspection.getTextWithMnemonic(module, component);
        if (twm != null) {
            this.checkTextWithMnemonic(module, component, twm, collector);
        }
    }

    @Nullable
    public static SupportCode.TextWithMnemonic getTextWithMnemonic(Module module, IComponent component) {
        Object propValue;
        if (module.isDisposed()) {
            return null;
        }
        IProperty prop = FormInspectionUtil.findProperty(component, "text");
        if (prop != null && (propValue = prop.getPropertyValue(component)) instanceof StringDescriptor) {
            StringDescriptor descriptor = (StringDescriptor)propValue;
            String value = component instanceof RadComponent ? StringDescriptorManager.getInstance(module).resolve((RadComponent)component, descriptor) : StringDescriptorManager.getInstance(module).resolve(descriptor, null);
            SupportCode.TextWithMnemonic twm = SupportCode.parseText((String)value);
            if (twm.myMnemonicIndex >= 0 && (FormInspectionUtil.isComponentClass(module, component, JLabel.class) || FormInspectionUtil.isComponentClass(module, component, AbstractButton.class))) {
                return twm;
            }
        }
        return null;
    }

    private void checkTextWithMnemonic(Module module, IComponent component, SupportCode.TextWithMnemonic twm, FormErrorCollector collector) {
        MnemonicKey key;
        IRootContainer root = FormEditingUtil.getRoot(component);
        MnemonicMap map = myContainerMnemonicMap.get().get(root);
        if (map.containsKey(key = DuplicateMnemonicInspection.buildMnemonicKey(twm, component))) {
            IProperty prop = FormInspectionUtil.findProperty(component, "text");
            IComponent oldComponent = (IComponent)map.get(key);
            collector.addError(this.getID(), component, prop, UIDesignerBundle.message("inspection.duplicate.mnemonics.message", FormInspectionUtil.getText(module, oldComponent), FormInspectionUtil.getText(module, component)), new EditorQuickFixProvider(){

                @Override
                public QuickFix createQuickFix(GuiEditor editor, RadComponent component) {
                    return new AssignMnemonicFix(editor, component, UIDesignerBundle.message("inspection.duplicate.mnemonics.quickfix", new Object[0]));
                }
            });
        } else {
            map.put(key, component);
        }
    }

    private static MnemonicKey buildMnemonicKey(SupportCode.TextWithMnemonic twm, IComponent component) {
        ArrayList<Integer> exclusiveContainerStack = new ArrayList<Integer>();
        IComponent child = component;
        for (IContainer parent = component.getParentContainer(); parent != null; parent = parent.getParentContainer()) {
            if (parent.areChildrenExclusive()) {
                exclusiveContainerStack.add(0, parent.indexOfComponent(child));
            }
            child = parent;
        }
        return new MnemonicKey(twm.getMnemonicChar(), exclusiveContainerStack);
    }

    private static class MnemonicMap
    extends HashMap<MnemonicKey, IComponent> {
        private MnemonicMap() {
        }
    }

    private static class MnemonicKey {
        private final char myMnemonicChar;
        private final List<Integer> myExclusiveContainerStack;

        public MnemonicKey(char mnemonicChar, List<Integer> exclusiveContainerStack) {
            this.myMnemonicChar = mnemonicChar;
            this.myExclusiveContainerStack = exclusiveContainerStack;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MnemonicKey that = (MnemonicKey)o;
            if (this.myMnemonicChar != that.myMnemonicChar) {
                return false;
            }
            return ((Object)this.myExclusiveContainerStack).equals(that.myExclusiveContainerStack);
        }

        public int hashCode() {
            int result = this.myMnemonicChar;
            result = 31 * result + ((Object)this.myExclusiveContainerStack).hashCode();
            return result;
        }
    }
}

