/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.ide.palette.PaletteGroup;
import com.intellij.ide.palette.PaletteItem;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GroupItem
implements Cloneable,
PaletteGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.palette.GroupItem");
    public static final DataKey<GroupItem> DATA_KEY = DataKey.create((String)GroupItem.class.getName());
    @NotNull
    private String myName;
    @NotNull
    private final ArrayList<ComponentItem> myItems;
    private boolean myReadOnly;
    private boolean mySpecialGroup;

    public GroupItem(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/palette/GroupItem.<init> must not be null");
        }
        this.myItems = new ArrayList();
        this.myReadOnly = false;
        this.mySpecialGroup = false;
        this.setName(name);
    }

    public GroupItem(boolean specialGroup) {
        this.myItems = new ArrayList();
        this.myReadOnly = false;
        this.mySpecialGroup = false;
        this.mySpecialGroup = specialGroup;
    }

    public GroupItem clone() {
        GroupItem result = new GroupItem(this.myName);
        for (ComponentItem myItem : this.myItems) {
            result.addItem(myItem.clone());
        }
        return result;
    }

    public boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getName() {
        String string;
        if (this.mySpecialGroup) {
            string = UIDesignerBundle.message("palette.special.group", new Object[0]);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/palette/GroupItem.getName must not return null");
            return string;
        }
        string = this.myName;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/palette/GroupItem.getName must not return null");
    }

    public String getTabName() {
        return "Swing";
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/palette/GroupItem.setName must not be null");
        }
        this.myName = name;
    }

    @NotNull
    public ComponentItem[] getItems() {
        ComponentItem[] componentItemArray = this.myItems.toArray(new ComponentItem[this.myItems.size()]);
        if (componentItemArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/palette/GroupItem.getItems must not return null");
        }
        return componentItemArray;
    }

    public void addItem(@NotNull ComponentItem item) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/palette/GroupItem.addItem must not be null");
        }
        LOG.assertTrue(!this.myItems.contains(item));
        this.myItems.add(item);
    }

    public void replaceItem(@NotNull ComponentItem itemToBeReplaced, @NotNull ComponentItem replacement) {
        if (itemToBeReplaced == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/palette/GroupItem.replaceItem must not be null");
        }
        if (replacement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/palette/GroupItem.replaceItem must not be null");
        }
        LOG.assertTrue(this.myItems.contains(itemToBeReplaced));
        int index = this.myItems.indexOf(itemToBeReplaced);
        this.myItems.set(index, replacement);
    }

    public void removeItem(@NotNull ComponentItem item) {
        if (item == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/palette/GroupItem.removeItem must not be null");
        }
        LOG.assertTrue(this.myItems.contains(item));
        this.myItems.remove(item);
    }

    public boolean contains(ComponentItem item) {
        return this.myItems.contains(item);
    }

    public boolean containsItemClass(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/palette/GroupItem.containsItemClass must not be null");
        }
        for (int i = this.myItems.size() - 1; i >= 0; --i) {
            if (!className.equals(this.myItems.get(i).getClassName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsItemCopy(@NotNull ComponentItem originalItem, String className) {
        if (originalItem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/palette/GroupItem.containsItemCopy must not be null");
        }
        for (int i = this.myItems.size() - 1; i >= 0; --i) {
            if (!className.equals(this.myItems.get(i).getClassName()) || originalItem == this.myItems.get(i)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ActionGroup getPopupActionGroup() {
        return (ActionGroup)ActionManager.getInstance().getAction("GuiDesigner.PaletteGroupPopupMenu");
    }

    @Nullable
    public Object getData(Project project, String dataId) {
        if (dataId.equals(this.getClass().getName())) {
            return this;
        }
        return null;
    }

    public void handleDrop(Project project, PaletteItem droppedItem, int index) {
        if (droppedItem instanceof ComponentItem) {
            ComponentItem componentItem = (ComponentItem)droppedItem;
            Palette palette = Palette.getInstance(project);
            int oldIndex = this.myItems.indexOf(componentItem);
            if (oldIndex >= 0) {
                if (index == -1 || oldIndex == index) {
                    return;
                }
                if (oldIndex < index) {
                    --index;
                }
                this.myItems.remove(oldIndex);
            } else {
                for (GroupItem groupItem : palette.getGroups()) {
                    if (!groupItem.myItems.contains(componentItem)) continue;
                    groupItem.removeItem(componentItem);
                    break;
                }
            }
            if (index == -1) {
                this.myItems.add(componentItem);
            } else {
                this.myItems.add(index, componentItem);
            }
            palette.fireGroupsChanged();
        }
    }

    public String toString() {
        return this.myName;
    }
}

