/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.actions.generate.equals;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.HashMap;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.actions.generate.GroovyCodeInsightBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrGenerateEqualsHelper {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.actions.generate.equals.GrGenerateEqualsHelper");
    private final PsiClass myClass;
    private final PsiField[] myEqualsFields;
    private final PsiField[] myHashCodeFields;
    private final HashSet<PsiField> myNonNullSet;
    private final GroovyPsiElementFactory myFactory;
    private String myParameterName;
    @NonNls
    private static final String BASE_OBJECT_PARAMETER_NAME = "object";
    @NonNls
    private static final String BASE_OBJECT_LOCAL_NAME = "that";
    @NonNls
    private static final String RESULT_VARIABLE = "result";
    @NonNls
    private static final String TEMP_VARIABLE = "temp";
    private String myClassInstanceName;
    @NonNls
    private static final HashMap<String, MessageFormat> PRIMITIVE_HASHCODE_FORMAT = new HashMap();
    private final boolean mySuperHasHashCode;
    private final Project myProject;
    private final boolean myCheckParameterWithInstanceof;
    @NonNls
    private static final MessageFormat ARRAY_COMPARER_MF = new MessageFormat("if (!java.util.Arrays.equals({1}, {0}.{1})) return false;\n");
    @NonNls
    private static final MessageFormat FIELD_COMPARER_MF = new MessageFormat("if ({1} != {0}.{1}) return false;\n");
    @NonNls
    private static final MessageFormat DOUBLE_FIELD_COMPARER_MF = new MessageFormat("if ({0}.compare({1}.{2}, {2}) != 0) return false;\n");

    public GrGenerateEqualsHelper(Project project, PsiClass aClass, PsiField[] equalsFields, PsiField[] hashCodeFields, PsiField[] nonNullFields, boolean useInstanceofToCheckParameterType) {
        this.myClass = aClass;
        this.myEqualsFields = equalsFields;
        this.myHashCodeFields = hashCodeFields;
        this.myProject = project;
        this.myCheckParameterWithInstanceof = useInstanceofToCheckParameterType;
        this.myNonNullSet = new HashSet();
        this.myNonNullSet.addAll(Arrays.asList(nonNullFields));
        this.myFactory = GroovyPsiElementFactory.getInstance(project);
        this.mySuperHasHashCode = this.superMethodExists(GrGenerateEqualsHelper.getHashCodeSignature());
    }

    private static String getUniqueLocalVarName(String base, PsiField[] fields) {
        boolean anyEqual;
        String id = base;
        int index = 0;
        block0: do {
            if (index > 0) {
                id = base + index;
            }
            ++index;
            anyEqual = false;
            for (PsiField equalsField : fields) {
                if (!id.equals(equalsField.getName())) continue;
                anyEqual = true;
                continue block0;
            }
        } while (anyEqual);
        return id;
    }

    public void run() {
        try {
            Collection<PsiMethod> members = this.generateMembers();
            for (PsiMethod member : members) {
                this.myClass.add((PsiElement)member);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public Collection<PsiMethod> generateMembers() throws IncorrectOperationException {
        PsiMethod equals = null;
        if (this.myEqualsFields != null && GrGenerateEqualsHelper.findMethod(this.myClass, GrGenerateEqualsHelper.getEqualsSignature(this.myProject, this.myClass.getResolveScope())) == null) {
            equals = this.createEquals();
        }
        PsiMethod hashCode = null;
        if (this.myHashCodeFields != null && GrGenerateEqualsHelper.findMethod(this.myClass, GrGenerateEqualsHelper.getHashCodeSignature()) == null) {
            if (this.myHashCodeFields.length > 0) {
                hashCode = this.createHashCode();
            } else {
                hashCode = this.myFactory.createMethodFromText("int hashCode() {\nreturn 0;\n}");
                if (!this.mySuperHasHashCode) {
                    // empty if block
                }
            }
        }
        if (hashCode != null && equals != null) {
            return Arrays.asList(equals, hashCode);
        }
        if (equals != null) {
            return Collections.singletonList(equals);
        }
        if (hashCode != null) {
            return Collections.singletonList(hashCode);
        }
        return Collections.emptyList();
    }

    private void addDoubleFieldComparison(StringBuffer buffer, PsiField field) {
        String type = PsiType.DOUBLE.equals(field.getType()) ? "Double" : "Float";
        Object[] parameters = new Object[]{type, this.myClassInstanceName, field.getName()};
        DOUBLE_FIELD_COMPARER_MF.format(parameters, buffer, (FieldPosition)null);
    }

    private void addArrayEquals(StringBuffer buffer, PsiField field) {
        PsiType fieldType = field.getType();
        if (GrGenerateEqualsHelper.isNestedArray(fieldType)) {
            buffer.append(" ");
            buffer.append(GroovyCodeInsightBundle.message("generate.equals.compare.nested.arrays.comment", field.getName()));
            buffer.append("\n");
            return;
        }
        if (GrGenerateEqualsHelper.isArrayOfObjects(fieldType)) {
            buffer.append(" ");
            buffer.append(GroovyCodeInsightBundle.message("generate.equals.compare.arrays.comment", new Object[0]));
            buffer.append("\n");
        }
        ARRAY_COMPARER_MF.format(this.getComparerFormatParameters(field), buffer, (FieldPosition)null);
    }

    private Object[] getComparerFormatParameters(PsiField field) {
        return new Object[]{this.myClassInstanceName, field.getName()};
    }

    private void addFieldComparison(StringBuffer buffer, PsiField field) {
        FIELD_COMPARER_MF.format(this.getComparerFormatParameters(field), buffer, (FieldPosition)null);
    }

    private void addInstanceOfToText(@NonNls StringBuffer buffer, String returnValue) {
        if (this.myCheckParameterWithInstanceof) {
            buffer.append("if (!(").append(this.myParameterName).append(" instanceof ").append(this.myClass.getName()).append(")) return ").append(returnValue).append(";\n");
        } else {
            buffer.append("if (").append("getClass() != ").append(this.myParameterName).append(".class) return ").append(returnValue).append(";\n");
        }
    }

    private void addEqualsPrologue(@NonNls StringBuffer buffer) {
        buffer.append("if (this.is(").append(this.myParameterName).append(")").append(") return true;\n");
        if (!this.superMethodExists(GrGenerateEqualsHelper.getEqualsSignature(this.myProject, this.myClass.getResolveScope()))) {
            this.addInstanceOfToText(buffer, Boolean.toString(false));
        } else {
            this.addInstanceOfToText(buffer, Boolean.toString(false));
            buffer.append("if (!super.equals(");
            buffer.append(this.myParameterName);
            buffer.append(")) return false;\n");
        }
    }

    private void addClassInstance(@NonNls StringBuffer buffer) {
        buffer.append("\n");
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
        if (settings.GENERATE_FINAL_LOCALS) {
            buffer.append("final ");
        }
        buffer.append(this.myClass.getName());
        buffer.append(" ").append(this.myClassInstanceName).append(" = (");
        buffer.append(this.myClass.getName());
        buffer.append(")");
        buffer.append(this.myParameterName);
        buffer.append(";\n\n");
    }

    private boolean superMethodExists(MethodSignature methodSignature) {
        LOG.assertTrue(this.myClass.isValid());
        PsiMethod superEquals = MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (MethodSignature)methodSignature, (boolean)true);
        if (superEquals == null) {
            return true;
        }
        if (superEquals.hasModifierProperty("abstract")) {
            return false;
        }
        return !"java.lang.Object".equals(superEquals.getContainingClass().getQualifiedName());
    }

    private PsiMethod createEquals() throws IncorrectOperationException {
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        String[] nameSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)PsiType.getJavaLangObject((PsiManager)this.myClass.getManager(), (GlobalSearchScope)this.myClass.getResolveScope())).names;
        String objectBaseName = nameSuggestions.length > 0 ? nameSuggestions[0] : BASE_OBJECT_PARAMETER_NAME;
        this.myParameterName = GrGenerateEqualsHelper.getUniqueLocalVarName(objectBaseName, this.myEqualsFields);
        PsiClassType classType = TypesUtil.createType(this.myClass.getQualifiedName(), this.myClass.getContext());
        nameSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)classType).names;
        String instanceBaseName = nameSuggestions.length > 0 && nameSuggestions[0].length() < 10 ? nameSuggestions[0] : BASE_OBJECT_LOCAL_NAME;
        this.myClassInstanceName = GrGenerateEqualsHelper.getUniqueLocalVarName(instanceBaseName, this.myEqualsFields);
        StringBuffer buffer = new StringBuffer();
        buffer.append("boolean equals(").append(this.myParameterName).append(") {\n");
        this.addEqualsPrologue(buffer);
        if (this.myEqualsFields.length > 0) {
            this.addClassInstance(buffer);
            ArrayList<PsiField> equalsFields = new ArrayList<PsiField>();
            equalsFields.addAll(Arrays.asList(this.myEqualsFields));
            Collections.sort(equalsFields, EqualsFieldsComparator.INSTANCE);
            for (PsiField field : equalsFields) {
                PsiClass aClass;
                if (field.hasModifierProperty("static")) continue;
                PsiType type = field.getType();
                if (type instanceof PsiArrayType) {
                    this.addArrayEquals(buffer, field);
                    continue;
                }
                if (type instanceof PsiPrimitiveType) {
                    if (PsiType.DOUBLE.equals(type) || PsiType.FLOAT.equals(type)) {
                        this.addDoubleFieldComparison(buffer, field);
                        continue;
                    }
                    this.addFieldComparison(buffer, field);
                    continue;
                }
                if (type instanceof PsiClassType && (aClass = ((PsiClassType)type).resolve()) != null && aClass.isEnum()) {
                    this.addFieldComparison(buffer, field);
                    continue;
                }
                this.addFieldComparison(buffer, field);
            }
        }
        buffer.append("\nreturn true;\n}");
        GrMethod result = this.myFactory.createMethodFromText(buffer.toString());
        GrParameter parameter = result.getParameterList().getParameters()[0];
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS);
        try {
            result = (GrMethod)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)result);
        }
        catch (IncorrectOperationException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiMethod createHashCode() throws IncorrectOperationException {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            buffer.append("int hashCode() {\n");
            if (!this.mySuperHasHashCode && this.myHashCodeFields.length == 1) {
                PsiField field = this.myHashCodeFields[0];
                String tempName = this.addTempForOneField(field, buffer);
                buffer.append("return ");
                if (field.getType() instanceof PsiPrimitiveType) {
                    GrGenerateEqualsHelper.addPrimitiveFieldHashCode(buffer, field, tempName);
                } else {
                    this.addFieldHashCode(buffer, field);
                }
                buffer.append(";\n}");
            } else if (this.myHashCodeFields.length > 0) {
                CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
                String resultName = GrGenerateEqualsHelper.getUniqueLocalVarName(settings.LOCAL_VARIABLE_NAME_PREFIX + RESULT_VARIABLE, this.myHashCodeFields);
                buffer.append("int ");
                buffer.append(resultName);
                boolean resultAssigned = false;
                if (this.mySuperHasHashCode) {
                    buffer.append(" = ");
                    this.addSuperHashCode(buffer);
                    resultAssigned = true;
                }
                buffer.append(";\n");
                String tempName = this.addTempDeclaration(buffer);
                for (PsiField field : this.myHashCodeFields) {
                    GrGenerateEqualsHelper.addTempAssignment(field, buffer, tempName);
                    buffer.append(resultName);
                    buffer.append(" = ");
                    if (resultAssigned) {
                        buffer.append("31 * ");
                        buffer.append(resultName);
                        buffer.append(" + ");
                    }
                    if (field.getType() instanceof PsiPrimitiveType) {
                        GrGenerateEqualsHelper.addPrimitiveFieldHashCode(buffer, field, tempName);
                    } else {
                        this.addFieldHashCode(buffer, field);
                    }
                    buffer.append(";\n");
                    resultAssigned = true;
                }
                buffer.append("return ");
                buffer.append(resultName);
                buffer.append(";\n}");
            } else {
                buffer.append("return 0;\n}");
            }
            GrMethod hashCode = this.myFactory.createMethodFromText(buffer.toString());
            try {
                hashCode = (GrMethod)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)hashCode);
            }
            catch (IncorrectOperationException e) {
                e.printStackTrace();
            }
            GrMethod grMethod = hashCode;
            return grMethod;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    private static void addTempAssignment(PsiField field, StringBuilder buffer, String tempName) {
        if (PsiType.DOUBLE.equals(field.getType())) {
            buffer.append(tempName);
            GrGenerateEqualsHelper.addTempForDoubleInitialization(field, buffer);
        }
    }

    private static void addTempForDoubleInitialization(PsiField field, StringBuilder buffer) {
        buffer.append(" = ").append(field.getName()).append(" != +0.0d ? Double.doubleToLongBits(");
        buffer.append(field.getName());
        buffer.append(") : 0L;\n");
    }

    @Nullable
    private String addTempDeclaration(StringBuilder buffer) {
        for (PsiField hashCodeField : this.myHashCodeFields) {
            if (!PsiType.DOUBLE.equals(hashCodeField.getType())) continue;
            String name = GrGenerateEqualsHelper.getUniqueLocalVarName(TEMP_VARIABLE, this.myHashCodeFields);
            buffer.append("long ").append(name).append(";\n");
            return name;
        }
        return null;
    }

    @Nullable
    private String addTempForOneField(PsiField field, StringBuilder buffer) {
        if (PsiType.DOUBLE.equals(field.getType())) {
            String name = GrGenerateEqualsHelper.getUniqueLocalVarName(TEMP_VARIABLE, this.myHashCodeFields);
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
            if (settings.GENERATE_FINAL_LOCALS) {
                buffer.append("final ");
            }
            buffer.append("long ").append(name);
            GrGenerateEqualsHelper.addTempForDoubleInitialization(field, buffer);
            return name;
        }
        return null;
    }

    private static void addPrimitiveFieldHashCode(StringBuilder buffer, PsiField field, String tempName) {
        MessageFormat format = (MessageFormat)PRIMITIVE_HASHCODE_FORMAT.get((Object)field.getType().getCanonicalText());
        buffer.append(format.format(new Object[]{field.getName(), tempName}));
    }

    private void addFieldHashCode(StringBuilder buffer, PsiField field) {
        String name = field.getName();
        if (this.myNonNullSet.contains(field)) {
            GrGenerateEqualsHelper.adjustHashCodeToArrays(buffer, field, name);
        } else {
            buffer.append("(");
            buffer.append(name);
            buffer.append(" != null ? ");
            GrGenerateEqualsHelper.adjustHashCodeToArrays(buffer, field, name);
            buffer.append(" : 0)");
        }
    }

    private static void adjustHashCodeToArrays(StringBuilder buffer, PsiField field, String name) {
        if (field.getType() instanceof PsiArrayType && LanguageLevel.JDK_1_5.compareTo((Enum)PsiUtil.getLanguageLevel((PsiElement)field)) <= 0) {
            buffer.append("Arrays.hashCode(");
            buffer.append(name);
            buffer.append(")");
        } else {
            buffer.append(name);
            buffer.append(".hashCode()");
        }
    }

    private void addSuperHashCode(StringBuilder buffer) {
        if (this.mySuperHasHashCode) {
            buffer.append("super.hashCode()");
        } else {
            buffer.append("0");
        }
    }

    static PsiMethod findMethod(PsiClass aClass, MethodSignature signature) {
        return MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)signature, (boolean)false);
    }

    private static void initPrimitiveHashcodeFormats() {
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"byte", (Object)new MessageFormat("(int) {0}"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"short", (Object)new MessageFormat("(int) {0}"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"int", (Object)new MessageFormat("{0}"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"long", (Object)new MessageFormat("(int) ({0} ^ ({0} >>> 32))"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"boolean", (Object)new MessageFormat("({0} ? 1 : 0)"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"float", (Object)new MessageFormat("({0} != +0.0f ? Float.floatToIntBits({0}) : 0)"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"double", (Object)new MessageFormat("(int) ({1} ^ ({1} >>> 32))"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"char", (Object)new MessageFormat("(int) {0}"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"void", (Object)new MessageFormat("0"));
        PRIMITIVE_HASHCODE_FORMAT.put((Object)"void", (Object)new MessageFormat("({0} ? 1 : 0)"));
    }

    public static boolean isNestedArray(PsiType aType) {
        if (!(aType instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)aType).getComponentType();
        return componentType instanceof PsiArrayType;
    }

    public static boolean isArrayOfObjects(PsiType aType) {
        if (!(aType instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)aType).getComponentType();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)componentType);
        if (psiClass == null) {
            return false;
        }
        String qName = psiClass.getQualifiedName();
        return "java.lang.Object".equals(qName);
    }

    public static MethodSignature getHashCodeSignature() {
        return MethodSignatureUtil.createMethodSignature((String)"hashCode", (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    public static MethodSignature getEqualsSignature(Project project, GlobalSearchScope scope) {
        PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)scope);
        return MethodSignatureUtil.createMethodSignature((String)"equals", (PsiType[])new PsiType[]{javaLangObject}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    static {
        GrGenerateEqualsHelper.initPrimitiveHashcodeFormats();
    }

    static class EqualsFieldsComparator
    implements Comparator<PsiField> {
        public static final EqualsFieldsComparator INSTANCE = new EqualsFieldsComparator();

        EqualsFieldsComparator() {
        }

        @Override
        public int compare(PsiField f1, PsiField f2) {
            if (f1.getType() instanceof PsiPrimitiveType && !(f2.getType() instanceof PsiPrimitiveType)) {
                return -1;
            }
            if (!(f1.getType() instanceof PsiPrimitiveType) && f2.getType() instanceof PsiPrimitiveType) {
                return 1;
            }
            String name1 = f1.getName();
            String name2 = f2.getName();
            assert (name1 != null && name2 != null);
            return name1.compareTo(name2);
        }
    }
}

