/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class ChangePackageQuickFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.annotator.intentions.ChangePackageQuickFix");
    private final GroovyFile myFile;
    private final String myNewPackageName;

    public ChangePackageQuickFix(GroovyFile file, String newPackageName) {
        this.myFile = file;
        this.myNewPackageName = newPackageName;
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("fix.package.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/ChangePackageQuickFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("fix.package.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/ChangePackageQuickFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/ChangePackageQuickFix.isAvailable must not be null");
        }
        return this.myFile.isValid() && this.myFile.getManager().isInProject((PsiElement)file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/ChangePackageQuickFix.invoke must not be null");
        }
        this.myFile.setPackageName(this.myNewPackageName);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

