/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.editor.template.expressions.ChooseTypeExpression;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrMemberOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.GroovyExpectedTypesProvider;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.SupertypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class CreateMethodFromUsageFix
implements IntentionAction {
    private final GrMemberOwner myTargetClass;
    private final GrReferenceExpression myRefExpression;

    public CreateMethodFromUsageFix(GrReferenceExpression refExpression, GrMemberOwner targetClass) {
        this.myRefExpression = refExpression;
        this.myTargetClass = targetClass;
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("create.method.from.usage", this.myRefExpression.getReferenceName());
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/CreateMethodFromUsageFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("create.from.usage.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/annotator/intentions/CreateMethodFromUsageFix.getFamilyName must not return null");
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateMethodFromUsageFix.isAvailable must not be null");
        }
        return this.myTargetClass.isValid() && this.myRefExpression.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        GrTypeDefinitionBody parent;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/annotator/intentions/CreateMethodFromUsageFix.invoke must not be null");
        }
        StringBuffer methodBuffer = new StringBuffer();
        if (PsiUtil.isInStaticContext(this.myRefExpression, this.myTargetClass)) {
            methodBuffer.append("static ");
        }
        methodBuffer.append("Object ").append(this.myRefExpression.getReferenceName()).append(" (");
        PsiType[] argTypes = PsiUtil.getArgumentTypes(this.myRefExpression, false);
        assert (argTypes != null);
        ChooseTypeExpression[] paramTypesExpressions = new ChooseTypeExpression[argTypes.length];
        for (int i = 0; i < argTypes.length; ++i) {
            PsiType argType = argTypes[i];
            if (argType == null) {
                argType = TypesUtil.getJavaLangObject(this.myRefExpression);
            }
            if (i > 0) {
                methodBuffer.append(", ");
            }
            methodBuffer.append("Object o").append(i);
            paramTypesExpressions[i] = new ChooseTypeExpression(new TypeConstraint[]{SupertypeConstraint.create(argType)}, this.myRefExpression.getManager());
        }
        methodBuffer.append(") {\n}");
        GrMethod method = GroovyPsiElementFactory.getInstance(project).createMethodFromText(methodBuffer.toString());
        GrMemberOwner owner = this.myTargetClass;
        TypeConstraint[] constraints = GroovyExpectedTypesProvider.calculateTypeConstraints((GrExpression)this.myRefExpression.getParent());
        GrTypeDefinitionBody grTypeDefinitionBody = parent = this.myTargetClass instanceof GrTypeDefinition ? ((GrTypeDefinition)this.myTargetClass).getBody() : ((GroovyScriptClass)this.myTargetClass).getContainingFile();
        if (PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)this.myRefExpression, (boolean)false)) {
            PsiElement prevParent = PsiTreeUtil.findPrevParent((PsiElement)parent, (PsiElement)this.myRefExpression);
            method = owner.addMemberDeclaration(method, prevParent.getNextSibling());
        } else {
            method = owner.addMemberDeclaration(method, null);
        }
        IntentionUtils.createTemplateForMethod(argTypes, paramTypesExpressions, method, owner, constraints, false);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

