/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrThisReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyAccessToStaticFieldLockedOnInstanceInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Threading issues" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovyAccessToStaticFieldLockedOnInstanceInspection.getGroupDisplayName must not return null");
        }
        return "Threading issues";
    }

    @NotNull
    public String getDisplayName() {
        if ("Access to static field locked on instance data" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovyAccessToStaticFieldLockedOnInstanceInspection.getDisplayName must not return null");
        }
        return "Access to static field locked on instance data";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if ("Access to static field <code>#ref</code> locked on instance data #loc" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovyAccessToStaticFieldLockedOnInstanceInspection.buildErrorString must not return null");
        }
        return "Access to static field <code>#ref</code> locked on instance data #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull GrReferenceExpression expression) {
            GrSynchronizedStatement syncStatement;
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/threading/GroovyAccessToStaticFieldLockedOnInstanceInspection$Visitor.visitReferenceExpression must not be null");
            }
            super.visitReferenceExpression(expression);
            boolean isLockedOnInstance = false;
            boolean isLockedOnClass = false;
            GrMethod containingMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, GrMethod.class);
            if (containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                if (containingMethod.hasModifierProperty("static")) {
                    isLockedOnClass = true;
                } else {
                    isLockedOnInstance = true;
                }
            }
            GrStatement elementToCheck = expression;
            while ((syncStatement = (GrSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)elementToCheck, GrSynchronizedStatement.class)) != null) {
                GrExpression lockExpression = syncStatement.getMonitor();
                if (lockExpression instanceof GrReferenceExpression) {
                    GrReferenceExpression reference = (GrReferenceExpression)lockExpression;
                    PsiElement referent = reference.resolve();
                    if (referent instanceof PsiField) {
                        PsiField referentField = (PsiField)referent;
                        if (referentField.hasModifierProperty("static")) {
                            isLockedOnClass = true;
                        } else {
                            isLockedOnInstance = true;
                        }
                    }
                } else if (lockExpression instanceof GrThisReferenceExpression) {
                    isLockedOnInstance = true;
                }
                elementToCheck = syncStatement;
            }
            if (!isLockedOnInstance || isLockedOnClass) {
                return;
            }
            PsiElement referent = expression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField referredField = (PsiField)referent;
            if (!referredField.hasModifierProperty("static") || Visitor.isConstant(referredField)) {
                return;
            }
            PsiClass containingClass = referredField.getContainingClass();
            if (!PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)expression, (boolean)false)) {
                return;
            }
            this.registerError(expression);
        }

        private static boolean isConstant(PsiField field) {
            return field.hasModifierProperty("final");
        }
    }
}

