/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovySynchronizedMethodInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Threading issues" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovySynchronizedMethodInspection.getGroupDisplayName must not return null");
        }
        return "Threading issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Synchronized method" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovySynchronizedMethodInspection.getDisplayName must not return null");
        }
        return "Synchronized method";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Synchronized method '#ref' #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethod(GrMethod grMethod) {
            super.visitMethod(grMethod);
            if (!grMethod.hasModifierProperty("synchronized")) {
                return;
            }
            this.registerMethodError(grMethod, new Object[0]);
        }
    }
}

