/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyUnconditionalWaitInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Threading issues" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovyUnconditionalWaitInspection.getGroupDisplayName must not return null");
        }
        return "Threading issues";
    }

    @NotNull
    public String getDisplayName() {
        if ("Unconditional 'wait' call" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovyUnconditionalWaitInspection.getDisplayName must not return null");
        }
        return "Unconditional 'wait' call";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if ("Unconditional call to <code>#ref()</code> #loc" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovyUnconditionalWaitInspection.buildErrorString must not return null");
        }
        return "Unconditional call to <code>#ref()</code> #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnconditionalWaitVisitor();
    }

    private static class UnconditionalWaitVisitor
    extends BaseInspectionVisitor {
        private UnconditionalWaitVisitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/threading/GroovyUnconditionalWaitInspection$UnconditionalWaitVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            GrOpenBlock body = method.getBlock();
            if (body != null) {
                this.checkBody(body);
            }
        }

        @Override
        public void visitSynchronizedStatement(@NotNull GrSynchronizedStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/threading/GroovyUnconditionalWaitInspection$UnconditionalWaitVisitor.visitSynchronizedStatement must not be null");
            }
            super.visitSynchronizedStatement(statement);
            GrOpenBlock body = statement.getBody();
            if (body != null) {
                this.checkBody(body);
            }
        }

        private void checkBody(GrCodeBlock body) {
            GrStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return;
            }
            for (GrStatement statement : statements) {
                if (UnconditionalWaitVisitor.isConditional(statement)) {
                    return;
                }
                if (!(statement instanceof GrMethodCallExpression)) continue;
                GrMethodCallExpression methodCallExpression = (GrMethodCallExpression)statement;
                GrExpression methodExpression = methodCallExpression.getInvokedExpression();
                if (!(methodExpression instanceof GrReferenceExpression)) {
                    return;
                }
                GrReferenceExpression reference = (GrReferenceExpression)methodExpression;
                String name = reference.getReferenceName();
                if (!"wait".equals(name)) {
                    return;
                }
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
                    return;
                }
                this.registerMethodCallError(methodCallExpression, new Object[0]);
            }
        }

        private static boolean isConditional(GrStatement statement) {
            return statement instanceof GrIfStatement;
        }
    }
}

