/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.selection;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.plugins.groovy.editor.selection.GroovyBasicSelectioner;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovyLiteralSelectioner
extends GroovyBasicSelectioner {
    public boolean canSelect(PsiElement e) {
        PsiElement parent = e.getParent();
        return GroovyLiteralSelectioner.isLiteral(e) || GroovyLiteralSelectioner.isLiteral(parent);
    }

    private static boolean isLiteral(PsiElement element) {
        if (element instanceof GrListOrMap) {
            return true;
        }
        if (!(element instanceof GrLiteral)) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        ASTNode[] children = node.getChildren(null);
        return children.length == 1 && (children[0].getElementType() == GroovyTokenTypes.mSTRING_LITERAL || children[0].getElementType() == GroovyTokenTypes.mGSTRING_LITERAL);
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> result = super.select(e, editorText, cursorOffset, editor);
        if (e instanceof GrListOrMap) {
            return result;
        }
        int startOffset = -1;
        int endOffset = -1;
        String text = e.getText();
        int stringOffset = e.getTextOffset();
        if (e.getNode().getElementType() == GroovyTokenTypes.mGSTRING_CONTENT) {
            int cur;
            int index = -1;
            while ((cur = text.indexOf(10, index + 1)) >= 0 && cur + stringOffset <= cursorOffset) {
                index = cur;
            }
            if (index >= 0) {
                startOffset = stringOffset + index + 1;
            }
            if ((index = text.indexOf(10, cursorOffset - stringOffset)) >= 0) {
                endOffset = stringOffset + index + 1;
            }
        }
        if (startOffset >= 0 && endOffset >= 0) {
            result.add(new TextRange(startOffset, endOffset));
        }
        String content = GrStringUtil.removeQuotes(text);
        int offset = stringOffset + text.indexOf(content);
        result.add(new TextRange(offset, offset + content.length()));
        return result;
    }
}

