/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.execution.Location;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyIcons;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptTypeEP;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public abstract class GroovyScriptType {
    public static final ExtensionPointName<GroovyScriptTypeEP> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.scriptType");
    public static final GroovyScriptType DEFAULT_TYPE = new GroovyScriptType(){

        @Override
        public boolean isSpecificScriptFile(GroovyFile file) {
            return true;
        }

        @Override
        public boolean shouldBeCompiled(GroovyFile script) {
            return true;
        }

        @Override
        @NotNull
        public Icon getScriptIcon() {
            Icon icon = GroovyIcons.GROOVY_ICON_16x16;
            if (icon == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/extensions/GroovyScriptType$1.getScriptIcon must not return null");
            }
            return icon;
        }

        @Override
        public GroovyScriptRunner getRunner() {
            return new DefaultGroovyScriptRunner();
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static GroovyScriptType getScriptType(@NotNull GroovyFile script) {
        GroovyScriptType groovyScriptType;
        if (script == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/extensions/GroovyScriptType.getScriptType must not be null");
        }
        assert (script.isScript());
        for (GroovyScriptTypeEP typeEP : (GroovyScriptTypeEP[])EP_NAME.getExtensions()) {
            GroovyScriptType descriptor = typeEP.getTypeDescriptor();
            if (!descriptor.isSpecificScriptFile(script)) continue;
            groovyScriptType = descriptor;
            if (groovyScriptType == null) throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/extensions/GroovyScriptType.getScriptType must not return null");
            return groovyScriptType;
        }
        groovyScriptType = DEFAULT_TYPE;
        if (groovyScriptType != null) return groovyScriptType;
        throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/extensions/GroovyScriptType.getScriptType must not return null");
    }

    public abstract boolean isSpecificScriptFile(GroovyFile var1);

    @NotNull
    public abstract Icon getScriptIcon();

    public void tuneConfiguration(@NotNull GroovyFile file, @NotNull GroovyScriptRunConfiguration configuration, Location location) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/extensions/GroovyScriptType.tuneConfiguration must not be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/extensions/GroovyScriptType.tuneConfiguration must not be null");
        }
    }

    public GlobalSearchScope patchResolveScope(@NotNull GroovyFile file, @NotNull GlobalSearchScope baseScope) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/extensions/GroovyScriptType.patchResolveScope must not be null");
        }
        if (baseScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/extensions/GroovyScriptType.patchResolveScope must not be null");
        }
        return baseScope;
    }

    @Nullable
    public GroovyScriptRunner getRunner() {
        return null;
    }

    public List<String> appendImplicitImports(@NotNull GroovyFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/extensions/GroovyScriptType.appendImplicitImports must not be null");
        }
        return Collections.emptyList();
    }

    public boolean shouldBeCompiled(GroovyFile script) {
        return false;
    }
}

