/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class AccessorReferencesSearcher
implements QueryExecutor<PsiReference, MethodReferencesSearch.SearchParameters> {
    public boolean execute(final MethodReferencesSearch.SearchParameters searchParameters, final Processor<PsiReference> consumer) {
        final PsiMethod method = searchParameters.getMethod();
        String propertyName = this.getPropertyName(method);
        if (propertyName == null) {
            return true;
        }
        SearchScope searchScope = PsiUtil.restrictScopeToGroovyFiles(new Computable<SearchScope>(){

            public SearchScope compute() {
                return searchParameters.getScope();
            }
        });
        PsiSearchHelper helper = PsiManager.getInstance((Project)method.getProject()).getSearchHelper();
        TextOccurenceProcessor processor = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                PsiReference[] refs;
                for (PsiReference ref : refs = element.getReferences()) {
                    if (!ref.getRangeInElement().contains(offsetInElement) || !ref.isReferenceTo((PsiElement)method)) continue;
                    return consumer.process((Object)ref);
                }
                return true;
            }
        };
        return helper.processElementsWithWord(processor, searchScope, propertyName, (short)1, false);
    }

    private String getPropertyName(final PsiMethod method) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return GroovyPropertyUtils.getPropertyName(method);
            }
        });
    }
}

