/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.formatter.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.processors.GroovyIndentProcessor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrThrowsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;

public class GroovyBlockGenerator
implements GroovyElementTypes {
    private static final TokenSet NESTED = TokenSet.create((IElementType[])new IElementType[]{REFERENCE_EXPRESSION, PATH_INDEX_PROPERTY, PATH_METHOD_CALL, PATH_PROPERTY_REFERENCE});

    public static List<Block> generateSubBlocks(ASTNode node, Alignment myAlignment, Wrap myWrap, CodeStyleSettings mySettings, GroovyBlock block) {
        ArrayList<Block> subBlocks;
        String text;
        PsiElement blockPsi = block.getNode().getPsi();
        if (blockPsi instanceof GrBinaryExpression && !(blockPsi.getParent() instanceof GrBinaryExpression)) {
            return GroovyBlockGenerator.generateForBinaryExpr(node, myWrap, mySettings);
        }
        if ((block.getNode().getElementType() == mSTRING_LITERAL || block.getNode().getElementType() == mGSTRING_LITERAL) && block.getTextRange().equals((Object)block.getNode().getTextRange()) && (text = block.getNode().getText()).length() > 6 && (text.substring(0, 3).equals("'''") && text.substring(text.length() - 3).equals("'''") || text.substring(0, 3).equals("\"\"\"") & text.substring(text.length() - 3).equals("\"\"\""))) {
            return GroovyBlockGenerator.generateForMultiLineString(block.getNode(), myAlignment, myWrap, mySettings);
        }
        if (block.getNode().getElementType() == mGSTRING_BEGIN && block.getTextRange().equals((Object)block.getNode().getTextRange()) && (text = block.getNode().getText()).length() > 3 && text.substring(0, 3).equals("\"\"\"")) {
            return GroovyBlockGenerator.generateForMultiLineGStringBegin(block.getNode(), myAlignment, myWrap, mySettings);
        }
        if (block.getNode().getElementType() == GSTRING) {
            subBlocks = new ArrayList<Block>();
            ASTNode[] children = GroovyBlockGenerator.getGroovyChildren(node);
            ASTNode prevChildNode = null;
            for (ASTNode childNode : children) {
                if (childNode.getTextRange().getLength() > 0) {
                    Indent indent = GroovyIndentProcessor.getChildIndent(block, prevChildNode, childNode);
                    subBlocks.add(new GroovyBlock(childNode, myAlignment, indent, myWrap, mySettings));
                }
                prevChildNode = childNode;
            }
            return subBlocks;
        }
        if (NESTED.contains(block.getNode().getElementType()) && blockPsi.getParent() != null && blockPsi.getParent().getNode() != null && !NESTED.contains(blockPsi.getParent().getNode().getElementType())) {
            return GroovyBlockGenerator.generateForNestedExpr(node, myAlignment, myWrap, mySettings);
        }
        if (GroovyBlockGenerator.isListLikeClause(blockPsi)) {
            subBlocks = new ArrayList();
            ASTNode[] children = node.getChildren(null);
            ASTNode prevChildNode = null;
            Alignment alignment = GroovyBlockGenerator.mustAlign(blockPsi, mySettings) ? Alignment.createAlignment() : null;
            for (ASTNode childNode : children) {
                if (!GroovyBlockGenerator.canBeCorrectBlock(childNode)) continue;
                Indent indent = GroovyIndentProcessor.getChildIndent(block, prevChildNode, childNode);
                subBlocks.add(new GroovyBlock(childNode, GroovyBlockGenerator.isKeyword(childNode) ? null : alignment, indent, myWrap, mySettings));
                prevChildNode = childNode;
            }
            return subBlocks;
        }
        subBlocks = new ArrayList();
        ASTNode[] children = GroovyBlockGenerator.getGroovyChildren(node);
        ASTNode prevChildNode = null;
        for (ASTNode childNode : children) {
            if (!GroovyBlockGenerator.canBeCorrectBlock(childNode)) continue;
            Indent indent = GroovyIndentProcessor.getChildIndent(block, prevChildNode, childNode);
            subBlocks.add(new GroovyBlock(childNode, blockPsi instanceof GrCodeBlock ? null : myAlignment, indent, myWrap, mySettings));
            prevChildNode = childNode;
        }
        return subBlocks;
    }

    private static boolean mustAlign(PsiElement blockPsi, CodeStyleSettings mySettings) {
        return blockPsi instanceof GrParameterList && mySettings.ALIGN_MULTILINE_PARAMETERS || blockPsi instanceof GrExtendsClause && mySettings.ALIGN_MULTILINE_EXTENDS_LIST || blockPsi instanceof GrThrowsClause && mySettings.ALIGN_MULTILINE_THROWS_LIST || blockPsi instanceof GrConditionalExpression && mySettings.ALIGN_MULTILINE_TERNARY_OPERATION || blockPsi instanceof GrArgumentList && mySettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS;
    }

    private static boolean isListLikeClause(PsiElement blockPsi) {
        return blockPsi instanceof GrParameterList || blockPsi instanceof GrArgumentList || blockPsi instanceof GrConditionalExpression || blockPsi instanceof GrExtendsClause || blockPsi instanceof GrThrowsClause;
    }

    private static boolean isKeyword(ASTNode node) {
        return node != null && (GroovyTokenTypes.KEYWORDS.contains(node.getElementType()) || GroovyTokenTypes.BRACES.contains(node.getElementType()));
    }

    private static List<Block> generateForMultiLineString(ASTNode node, Alignment myAlignment, Wrap myWrap, CodeStyleSettings mySettings) {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        final int start = node.getTextRange().getStartOffset();
        final int end = node.getTextRange().getEndOffset();
        subBlocks.add(new GroovyBlock(node, myAlignment, Indent.getNoneIndent(), myWrap, mySettings){

            @Override
            @NotNull
            public TextRange getTextRange() {
                TextRange textRange = new TextRange(start, start + 3);
                if (textRange == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyBlockGenerator$1.getTextRange must not return null");
                }
                return textRange;
            }
        });
        subBlocks.add(new GroovyBlock(node, myAlignment, Indent.getAbsoluteNoneIndent(), myWrap, mySettings){

            @Override
            @NotNull
            public TextRange getTextRange() {
                TextRange textRange = new TextRange(start + 3, end - 3);
                if (textRange == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyBlockGenerator$2.getTextRange must not return null");
                }
                return textRange;
            }
        });
        subBlocks.add(new GroovyBlock(node, myAlignment, Indent.getAbsoluteNoneIndent(), myWrap, mySettings){

            @Override
            @NotNull
            public TextRange getTextRange() {
                TextRange textRange = new TextRange(end - 3, end);
                if (textRange == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyBlockGenerator$3.getTextRange must not return null");
                }
                return textRange;
            }
        });
        return subBlocks;
    }

    private static List<Block> generateForMultiLineGStringBegin(ASTNode node, Alignment myAlignment, Wrap myWrap, CodeStyleSettings mySettings) {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        final int start = node.getTextRange().getStartOffset();
        final int end = node.getTextRange().getEndOffset();
        subBlocks.add(new GroovyBlock(node, myAlignment, Indent.getNoneIndent(), myWrap, mySettings){

            @Override
            @NotNull
            public TextRange getTextRange() {
                TextRange textRange = new TextRange(start, start + 3);
                if (textRange == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyBlockGenerator$4.getTextRange must not return null");
                }
                return textRange;
            }
        });
        subBlocks.add(new GroovyBlock(node, myAlignment, Indent.getAbsoluteNoneIndent(), myWrap, mySettings){

            @Override
            @NotNull
            public TextRange getTextRange() {
                TextRange textRange = new TextRange(start + 3, end);
                if (textRange == null) {
                    throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/formatter/GroovyBlockGenerator$5.getTextRange must not return null");
                }
                return textRange;
            }
        });
        return subBlocks;
    }

    private static boolean canBeCorrectBlock(ASTNode node) {
        return node.getText().trim().length() > 0;
    }

    private static ASTNode[] getGroovyChildren(ASTNode node) {
        PsiElement psi = node.getPsi();
        if (psi instanceof OuterLanguageElement) {
            TextRange range = node.getTextRange();
            ArrayList<ASTNode> childList = new ArrayList<ASTNode>();
            PsiFile groovyFile = psi.getContainingFile().getViewProvider().getPsi(GroovyFileType.GROOVY_LANGUAGE);
            if (groovyFile instanceof GroovyFileBase) {
                GroovyBlockGenerator.addChildNodes((PsiElement)groovyFile, childList, range);
            }
            return childList.toArray(new ASTNode[childList.size()]);
        }
        return node.getChildren(null);
    }

    private static void addChildNodes(PsiElement elem, ArrayList<ASTNode> childNodes, TextRange range) {
        ASTNode node = elem.getNode();
        if (range.contains(elem.getTextRange()) && node != null) {
            childNodes.add(node);
        } else {
            for (PsiElement child : elem.getChildren()) {
                GroovyBlockGenerator.addChildNodes(child, childNodes, range);
            }
        }
    }

    private static List<Block> generateForBinaryExpr(ASTNode node, Wrap myWrap, CodeStyleSettings mySettings) {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        Alignment alignment = mySettings.ALIGN_MULTILINE_BINARY_OPERATION ? Alignment.createAlignment() : null;
        GrBinaryExpression myExpr = (GrBinaryExpression)node.getPsi();
        ASTNode[] children = node.getChildren(null);
        if (myExpr.getLeftOperand() instanceof GrBinaryExpression) {
            GroovyBlockGenerator.addBinaryChildrenRecursively(myExpr.getLeftOperand(), subBlocks, Indent.getContinuationWithoutFirstIndent(), alignment, myWrap, mySettings);
        }
        for (ASTNode childNode : children) {
            if (!GroovyBlockGenerator.canBeCorrectBlock(childNode) || childNode.getPsi() instanceof GrBinaryExpression) continue;
            subBlocks.add(new GroovyBlock(childNode, alignment, Indent.getContinuationWithoutFirstIndent(), myWrap, mySettings));
        }
        if (myExpr.getRightOperand() instanceof GrBinaryExpression) {
            GroovyBlockGenerator.addBinaryChildrenRecursively(myExpr.getRightOperand(), subBlocks, Indent.getContinuationWithoutFirstIndent(), alignment, myWrap, mySettings);
        }
        return subBlocks;
    }

    private static void addBinaryChildrenRecursively(PsiElement elem, List<Block> list, Indent indent, Alignment alignment, Wrap myWrap, CodeStyleSettings mySettings) {
        if (elem == null) {
            return;
        }
        ASTNode[] children = elem.getNode().getChildren(null);
        if (elem instanceof GrBinaryExpression) {
            GrBinaryExpression myExpr = (GrBinaryExpression)elem;
            if (myExpr.getLeftOperand() instanceof GrBinaryExpression) {
                GroovyBlockGenerator.addBinaryChildrenRecursively(myExpr.getLeftOperand(), list, Indent.getContinuationWithoutFirstIndent(), alignment, myWrap, mySettings);
            }
            for (ASTNode childNode : children) {
                if (!GroovyBlockGenerator.canBeCorrectBlock(childNode) || childNode.getPsi() instanceof GrBinaryExpression) continue;
                list.add(new GroovyBlock(childNode, alignment, indent, myWrap, mySettings));
            }
            if (myExpr.getRightOperand() instanceof GrBinaryExpression) {
                GroovyBlockGenerator.addBinaryChildrenRecursively(myExpr.getRightOperand(), list, Indent.getContinuationWithoutFirstIndent(), alignment, myWrap, mySettings);
            }
        }
    }

    private static List<Block> generateForNestedExpr(ASTNode node, Alignment myAlignment, Wrap myWrap, CodeStyleSettings mySettings) {
        ArrayList<Block> subBlocks = new ArrayList<Block>();
        ASTNode[] children = node.getChildren(null);
        if (children.length > 0 && NESTED.contains(children[0].getElementType())) {
            GroovyBlockGenerator.addNestedChildrenRecursively(children[0].getPsi(), subBlocks, myAlignment, myWrap, mySettings);
        } else if (GroovyBlockGenerator.canBeCorrectBlock(children[0])) {
            subBlocks.add(new GroovyBlock(children[0], myAlignment, Indent.getContinuationWithoutFirstIndent(), myWrap, mySettings));
        }
        if (children.length > 1) {
            for (ASTNode childNode : children) {
                if (!GroovyBlockGenerator.canBeCorrectBlock(childNode) || children[0] == childNode) continue;
                subBlocks.add(new GroovyBlock(childNode, myAlignment, Indent.getContinuationWithoutFirstIndent(), myWrap, mySettings));
            }
        }
        return subBlocks;
    }

    private static void addNestedChildrenRecursively(PsiElement elem, List<Block> list, Alignment myAlignment, Wrap myWrap, CodeStyleSettings mySettings) {
        ASTNode[] children = elem.getNode().getChildren(null);
        if (children.length > 0 && NESTED.contains(children[0].getElementType())) {
            GroovyBlockGenerator.addNestedChildrenRecursively(children[0].getPsi(), list, myAlignment, myWrap, mySettings);
        } else if (GroovyBlockGenerator.canBeCorrectBlock(children[0])) {
            list.add(new GroovyBlock(children[0], myAlignment, Indent.getContinuationWithoutFirstIndent(), myWrap, mySettings));
        }
        if (children.length > 1) {
            for (ASTNode childNode : children) {
                if (!GroovyBlockGenerator.canBeCorrectBlock(childNode) || children[0] == childNode) continue;
                if (elem.getNode() != null && NESTED.contains(elem.getNode().getElementType())) {
                    list.add(new GroovyBlock(childNode, myAlignment, Indent.getContinuationWithoutFirstIndent(), myWrap, mySettings));
                    continue;
                }
                list.add(new GroovyBlock(childNode, myAlignment, Indent.getNoneIndent(), myWrap, mySettings));
            }
        }
    }
}

