/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.gradle;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.AbstractGroovyLibraryManager;
import org.jetbrains.plugins.groovy.gradle.GradleSettings;

public class GradleLibraryManager
extends AbstractGroovyLibraryManager {
    public static final Icon GRADLE_ICON = IconLoader.getIcon((String)"/icons/gradle/gradle.png");
    @NonNls
    static final Pattern GRADLE_JAR_FILE_PATTERN = Pattern.compile("gradle-(core-)?(\\d.*)\\.jar");
    @NonNls
    static final Pattern ANY_GRADLE_JAR_FILE_PATTERN = Pattern.compile("gradle-(.*)\\.jar");

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = GRADLE_ICON;
        if (icon == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gradle/GradleLibraryManager.getIcon must not return null");
        }
        return icon;
    }

    @Override
    @Nls
    public String getLibraryVersion(@NotNull Library library, LibrariesContainer container) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradleLibraryManager.getLibraryVersion must not be null");
        }
        return GradleLibraryManager.getGradleVersion(container.getLibraryFiles(library, OrderRootType.CLASSES));
    }

    @Nullable
    private static String getGradleVersion(VirtualFile[] libraryFiles) {
        for (VirtualFile file : libraryFiles) {
            String version = GradleLibraryManager.getGradleJarVersion(file);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    @Override
    public boolean isSDKHome(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradleLibraryManager.isSDKHome must not be null");
        }
        return GradleLibraryManager.isGradleSdkHome(file);
    }

    public static boolean isGradleSdkHome(VirtualFile file) {
        VirtualFile lib = file.findChild("lib");
        if (lib == null) {
            return false;
        }
        return GradleLibraryManager.isGradleSdk(lib.getChildren());
    }

    @Nullable
    public static VirtualFile getSdkHome(@Nullable Module module, @NotNull Project project) {
        VirtualFile cpHome;
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradleLibraryManager.getSdkHome must not be null");
        }
        if (module != null && (cpHome = GradleLibraryManager.getSdkHomeFromClasspath(module)) != null) {
            return cpHome;
        }
        return GradleSettings.getInstance(project).getSdkHome();
    }

    @Nullable
    public static VirtualFile getSdkHomeFromClasspath(Module module) {
        VirtualFile parent;
        VirtualFile gradleJar = GradleLibraryManager.findGradleJar(ModuleRootManager.getInstance((Module)module).getFiles(OrderRootType.CLASSES));
        if (gradleJar != null && (parent = gradleJar.getParent()) != null && "lib".equals(parent.getName())) {
            return parent.getParent();
        }
        return null;
    }

    @Nullable
    private static VirtualFile findGradleJar(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (!GRADLE_JAR_FILE_PATTERN.matcher(file.getName()).matches()) continue;
            return PathUtil.getLocalFile((VirtualFile)file);
        }
        return null;
    }

    public static boolean isGradleSdk(VirtualFile[] files) {
        return GradleLibraryManager.findGradleJar(files) != null;
    }

    @Override
    public boolean managesLibrary(@NotNull Library library, LibrariesContainer container) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/gradle/GradleLibraryManager.managesLibrary must not be null");
        }
        return GradleLibraryManager.isGradleSdk(container.getLibraryFiles(library, OrderRootType.CLASSES));
    }

    @Override
    @NotNull
    public String getSDKVersion(String path) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        for (VirtualFile virtualFile : file.findChild("lib").getChildren()) {
            String version = GradleLibraryManager.getGradleJarVersion(virtualFile);
            if (version == null) continue;
            String string = version;
            if (string == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gradle/GradleLibraryManager.getSDKVersion must not return null");
            }
            return string;
        }
        throw new AssertionError((Object)path);
    }

    @Nullable
    private static String getGradleJarVersion(VirtualFile file) {
        Matcher matcher = GRADLE_JAR_FILE_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    @Override
    @Nls
    @NotNull
    public String getLibraryCategoryName() {
        if ("Gradle" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/gradle/GradleLibraryManager.getLibraryCategoryName must not return null");
        }
        return "Gradle";
    }

    @Override
    protected void fillLibrary(String path, Library.ModifiableModel model) {
        File[] jars;
        File lib = new File(path + "/lib");
        File[] fileArray = jars = lib.exists() ? lib.listFiles() : new File[]{};
        if (jars != null) {
            for (File file : jars) {
                if (!file.getName().endsWith(".jar")) continue;
                model.addRoot(VfsUtil.getUrlForLibraryRoot((File)file), OrderRootType.CLASSES);
            }
        }
    }
}

