/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.plugins.groovy.intentions.base.ErrorUtil;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class ConditionalToElvisPredicate
implements PsiElementPredicate {
    @Override
    public boolean satisfiedBy(PsiElement element) {
        GrBinaryExpression binaryExpression;
        if (!(element instanceof GrConditionalExpression) || ErrorUtil.containsError(element)) {
            return false;
        }
        GrConditionalExpression expr = (GrConditionalExpression)element;
        if (expr.getThenBranch() == null || expr.getElseBranch() == null) {
            return false;
        }
        GrExpression condition = expr.getCondition();
        if (condition instanceof GrBinaryExpression && GroovyTokenTypes.mNOT_EQUAL == (binaryExpression = (GrBinaryExpression)condition).getOperationTokenType()) {
            GrExpression left = binaryExpression.getLeftOperand();
            GrExpression right = binaryExpression.getRightOperand();
            if (left instanceof GrLiteral && "null".equals(left.getText()) && right != null) {
                return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)right, (PsiElement)expr.getThenBranch());
            }
            if (right instanceof GrLiteral && "null".equals(right.getText()) && left != null) {
                return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)left, (PsiElement)expr.getThenBranch());
            }
        }
        return false;
    }
}

