/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.DummyIdentifierPatcher;
import com.intellij.codeInsight.completion.FileCopyPatcher;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementFactory;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovyInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.GroovyInsertHandlerAdapter;
import org.jetbrains.plugins.groovy.lang.completion.getters.ClassesGetter;
import org.jetbrains.plugins.groovy.lang.completion.handlers.AfterNewClassInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.handlers.ArrayInsertHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyCompletionContributor
extends CompletionContributor {
    private static final ElementPattern<PsiElement> AFTER_NEW = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withText("new")).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement().withText("throw"))))).withSuperParent(3, GrVariable.class);
    private static final ElementPattern<PsiElement> AFTER_DOT = ((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"."})).withParent(GrReferenceExpression.class);
    private static final String[] MODIFIERS = new String[]{"private", "public", "protected", "transient", "abstract", "native", "volatile", "strictfp", "def", "final", "synchronized", "static"};
    private static final ElementPattern<PsiElement> TYPE_IN_VARIABLE_DECLARATION_AFTER_MODIFIER = PlatformPatterns.or((ElementPattern[])new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiElement.class).withParent(GrVariable.class)).afterLeaf(MODIFIERS), PlatformPatterns.psiElement(PsiElement.class).withParent(GrParameter.class)});
    private static final String[] THIS_SUPER = new String[]{"this", "super"};

    private static boolean isReferenceInNewExpression(PsiElement reference) {
        if (!(reference instanceof GrCodeReferenceElement)) {
            return false;
        }
        PsiElement parent = reference.getParent();
        while (parent instanceof GrCodeReferenceElement) {
            parent = parent.getParent();
        }
        return parent instanceof GrNewExpression;
    }

    public GroovyCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(PsiElement.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, final @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$1.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$1.addCompletions must not be null");
                }
                PsiElement position = parameters.getPosition();
                PsiElement reference = position.getParent();
                if (reference == null) {
                    return;
                }
                if (GroovyCompletionContributor.isReferenceInNewExpression(reference)) {
                    ((GrCodeReferenceElement)reference).processVariants(new Consumer<Object>(){

                        public void consume(Object element) {
                            if (element instanceof PsiClass) {
                                PsiClass clazz = (PsiClass)element;
                                MutableLookupElement lookupElement = LookupElementFactory.getInstance().createLookupElement((PsiNamedElement)clazz);
                                result.addElement(GroovyCompletionUtil.setTailTypeForConstructor(clazz, (LookupElement)lookupElement));
                            } else {
                                result.addElement(LookupItemUtil.objectToLookupItem((Object)element));
                            }
                        }
                    });
                } else if (reference instanceof GrReferenceElement) {
                    ((GrReferenceElement)reference).processVariants(new Consumer<Object>(){

                        public void consume(Object element) {
                            LookupElement lookupElement = LookupItemUtil.objectToLookupItem((Object)element);
                            if (lookupElement instanceof LookupItem) {
                                lookupElement = ((LookupItem)lookupElement).setInsertHandler((InsertHandler)new GroovyInsertHandlerAdapter());
                            }
                            result.addElement(lookupElement);
                        }
                    });
                }
            }
        });
        this.extend(CompletionType.SMART, AFTER_NEW, (CompletionProvider)new CompletionProvider<CompletionParameters>(false){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext matchingContext, final @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$2.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$2.addCompletions must not be null");
                }
                final PsiElement identifierCopy = parameters.getPosition();
                PsiFile file = parameters.getOriginalFile();
                SmartList expectedClassTypes = new SmartList();
                ArrayList expectedArrayTypes = new ArrayList();
                ApplicationManager.getApplication().runReadAction(new Runnable((List)expectedClassTypes, expectedArrayTypes){
                    final /* synthetic */ List val$expectedClassTypes;
                    final /* synthetic */ List val$expectedArrayTypes;
                    {
                        this.val$expectedClassTypes = list;
                        this.val$expectedArrayTypes = list2;
                    }

                    @Override
                    public void run() {
                        PsiType psiType = ((GrVariable)identifierCopy.getParent().getParent().getParent()).getTypeGroovy();
                        if (psiType instanceof PsiClassType) {
                            PsiType type = JavaCompletionUtil.eliminateWildcards((PsiType)JavaCompletionUtil.originalize((PsiType)psiType));
                            PsiClassType classType = (PsiClassType)type;
                            if (classType.resolve() != null) {
                                this.val$expectedClassTypes.add(classType);
                            }
                        } else if (psiType instanceof PsiArrayType) {
                            this.val$expectedArrayTypes.add((PsiArrayType)psiType);
                        }
                    }
                });
                for (final PsiArrayType type : expectedArrayTypes) {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            LookupItem item = (LookupItem)LookupItemUtil.objectToLookupItem((Object)JavaCompletionUtil.eliminateWildcards((PsiType)type));
                            item.setAttribute(LookupItem.DONT_CHECK_FOR_INNERS, (Object)"");
                            if (item.getObject() instanceof PsiClass) {
                                JavaCompletionUtil.setShowFQN((LookupItem)item);
                            }
                            item.setInsertHandler((InsertHandler)new ArrayInsertHandler());
                            result.addElement((LookupElement)item);
                        }
                    });
                }
                JavaSmartCompletionContributor.processInheritors((CompletionParameters)parameters, (PsiElement)identifierCopy, (PsiFile)file, (Collection)expectedClassTypes, (Consumer)new Consumer<PsiType>(){

                    public void consume(PsiType type) {
                        GroovyCompletionContributor.addExpectedType(result, type, identifierCopy);
                    }
                }, (PrefixMatcher)result.getPrefixMatcher());
            }
        });
        this.extend(CompletionType.BASIC, AFTER_DOT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$3.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$3.addCompletions must not be null");
                }
                PsiElement position = parameters.getPosition();
                assert (position.getParent() instanceof GrReferenceExpression);
                GrReferenceExpression refExpr = (GrReferenceExpression)position.getParent();
                GrExpression qualifier = refExpr.getQualifierExpression();
                if (!(qualifier instanceof GrReferenceExpression)) {
                    return;
                }
                GrReferenceExpression referenceExpression = (GrReferenceExpression)qualifier;
                PsiElement resolved = referenceExpression.resolve();
                if (!(resolved instanceof PsiClass)) {
                    return;
                }
                if (!PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, position, false)) {
                    return;
                }
                for (String keyword : THIS_SUPER) {
                    LookupItem item = (LookupItem)LookupItemUtil.objectToLookupItem((Object)keyword);
                    item.setAttribute(LookupItem.DONT_CHECK_FOR_INNERS, (Object)"");
                    result.addElement((LookupElement)item);
                }
            }
        });
        this.extend(CompletionType.BASIC, TYPE_IN_VARIABLE_DECLARATION_AFTER_MODIFIER, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$4.addCompletions must not be null");
                }
                if (result == null) {
                    throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor$4.addCompletions must not be null");
                }
                PsiElement position = parameters.getPosition();
                if (!GroovyCompletionUtil.isFirstElementAfterModifiersInVariableDeclaration(position, true)) {
                    return;
                }
                for (Object variant : new ClassesGetter().get(parameters.getPosition(), null)) {
                    String lookupString = variant instanceof PsiElement ? PsiUtilBase.getName((PsiElement)((PsiElement)variant)) : variant.toString();
                    if (lookupString == null) continue;
                    LookupElementBuilder builder = LookupElementBuilder.create((Object)variant, (String)lookupString);
                    if (variant instanceof Iconable) {
                        builder = builder.setIcon(((Iconable)variant).getIcon(1));
                    }
                    if (variant instanceof PsiClass) {
                        String packageName = PsiFormatUtil.getPackageDisplayName((PsiClass)((PsiClass)variant));
                        builder = builder.setTailText(" (" + packageName + ")", true);
                    }
                    builder.setInsertHandler((InsertHandler)new GroovyInsertHandler());
                    result.addElement((LookupElement)builder);
                }
            }
        });
    }

    private static boolean checkForInnerClass(PsiClass psiClass, PsiElement identifierCopy) {
        return !com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)psiClass) || PsiUtil.hasEnclosingInstanceInScope(psiClass.getContainingClass(), identifierCopy, true);
    }

    private static void addExpectedType(CompletionResultSet result, PsiType type, PsiElement place) {
        if (!JavaCompletionUtil.hasAccessibleConstructor((PsiType)type)) {
            return;
        }
        PsiClass psiClass = com.intellij.psi.util.PsiUtil.resolveClassInType((PsiType)type);
        if (psiClass == null) {
            return;
        }
        if (psiClass.isInterface() || psiClass.hasModifierProperty("abstract")) {
            return;
        }
        if (!GroovyCompletionContributor.checkForInnerClass(psiClass, place)) {
            return;
        }
        LookupItem item = (LookupItem)LookupItemUtil.objectToLookupItem((Object)JavaCompletionUtil.eliminateWildcards((PsiType)type));
        item.setAttribute(LookupItem.DONT_CHECK_FOR_INNERS, (Object)"");
        JavaCompletionUtil.setShowFQN((LookupItem)item);
        item.setInsertHandler((InsertHandler)new AfterNewClassInsertHandler((PsiClassType)type, place));
        result.addElement((LookupElement)item);
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionContributor.beforeCompletion must not be null");
        }
        PsiFile file = context.getFile();
        Project project = context.getProject();
        JavaCompletionUtil.initOffsets((PsiFile)file, (Project)project, (OffsetMap)context.getOffsetMap());
        if (context.getCompletionType() == CompletionType.BASIC && file instanceof GroovyFile) {
            if (GroovyCompletionContributor.semicolonNeeded(context)) {
                context.setFileCopyPatcher((FileCopyPatcher)new DummyIdentifierPatcher("IntellijIdeaRulezzz;"));
            } else if (GroovyCompletionContributor.isInClosurePropertyParameters(context)) {
                context.setFileCopyPatcher((FileCopyPatcher)new DummyIdentifierPatcher("IntellijIdeaRulezzz->"));
            }
        }
    }

    private static boolean isInClosurePropertyParameters(CompletionInitializationContext context) {
        PsiFile file = context.getFile();
        PsiElement position = file.findElementAt(context.getStartOffset());
        if (position == null) {
            return false;
        }
        GrVariableDeclaration declaration = (GrVariableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)position, GrVariableDeclaration.class, (boolean)false, (Class[])new Class[]{GrStatement.class});
        if (declaration == null) {
            PsiElement prev = position.getPrevSibling();
            if ((prev = PsiUtil.skipWhitespaces(prev, false)) instanceof PsiErrorElement) {
                prev = prev.getPrevSibling();
            }
            if ((prev = PsiUtil.skipWhitespaces(prev, false)) instanceof GrVariableDeclaration) {
                declaration = (GrVariableDeclaration)prev;
            }
        }
        if (declaration != null) {
            if (!(declaration.getParent() instanceof GrClosableBlock)) {
                return false;
            }
            PsiElement prevSibling = PsiUtil.skipWhitespaces(declaration.getPrevSibling(), false);
            return prevSibling instanceof GrParameterList;
        }
        return false;
    }

    private static boolean semicolonNeeded(CompletionInitializationContext context) {
        HighlighterIterator iterator = ((EditorEx)context.getEditor()).getHighlighter().createIterator(context.getStartOffset());
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getTokenType() == GroovyTokenTypes.mIDENT) {
            iterator.advance();
        }
        if (!iterator.atEnd() && iterator.getTokenType() == GroovyTokenTypes.mLPAREN) {
            return true;
        }
        while (!iterator.atEnd() && GroovyTokenTypes.WHITE_SPACES_OR_COMMENTS.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (iterator.atEnd() || iterator.getTokenType() != GroovyTokenTypes.mIDENT) {
            return false;
        }
        iterator.advance();
        while (!iterator.atEnd() && GroovyTokenTypes.WHITE_SPACES_OR_COMMENTS.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        return true;
    }
}

