/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.documentation;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.LinkedHashSet;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyPresentationUtil {
    private static final int CONSTRAINTS_NUMBER = 2;

    public static String getParameterPresentation(GrParameter parameter, PsiSubstitutor substitutor) {
        StringBuilder builder = new StringBuilder();
        PsiType type = parameter.getTypeGroovy();
        if (type != null) {
            type = substitutor.substitute(type);
            return builder.append(type.getPresentableText()).append(" ").append(parameter.getName()).toString();
        }
        builder.append(parameter.getName());
        final LinkedHashSet structural = new LinkedHashSet();
        ReferencesSearch.search((PsiElement)parameter).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference ref) {
                PsiElement parent = ref.getElement().getParent();
                if (parent instanceof GrReferenceExpression) {
                    if (structural.size() >= 2) {
                        structural.add("...");
                        return false;
                    }
                    StringBuilder builder1 = new StringBuilder();
                    builder1.append(((GrReferenceElement)parent).getReferenceName());
                    PsiType[] argTypes = PsiUtil.getArgumentTypes(parent, true);
                    if (argTypes != null) {
                        builder1.append("(");
                        if (argTypes.length > 0) {
                            builder1.append(argTypes.length);
                            if (argTypes.length == 1) {
                                builder1.append(" arg");
                            } else {
                                builder1.append(" args");
                            }
                        }
                        builder1.append(")");
                    }
                    structural.add(builder1.toString());
                }
                return true;
            }
        });
        if (!structural.isEmpty()) {
            builder.append(".");
            String[] array = ArrayUtil.toStringArray(structural);
            if (array.length > 1) {
                builder.append("[");
            }
            for (int i = 0; i < array.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(array[i]);
            }
            if (array.length > 1) {
                builder.append("]");
            }
        }
        return builder.toString();
    }
}

