/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.editor.actions.moveUpDown.LineRange;

abstract class Mover {
    protected final boolean isDown;
    @NotNull
    protected LineRange toMove;
    protected LineRange toMove2;

    protected Mover(boolean isDown) {
        this.isDown = isDown;
    }

    protected abstract boolean checkAvailable(Editor var1, PsiFile var2);

    public final void move(Editor editor, PsiFile file) {
        if (this.toMove2 == null) {
            return;
        }
        Document document = editor.getDocument();
        int start = Mover.getLineStartSafeOffset(document, this.toMove.startLine);
        int end = Mover.getLineStartSafeOffset(document, this.toMove.endLine);
        RangeMarker range1 = document.createRangeMarker(start, end);
        int start2 = Mover.getLineStartSafeOffset(document, this.toMove2.startLine);
        int end2 = Mover.getLineStartSafeOffset(document, this.toMove2.endLine);
        RangeMarker range2 = document.createRangeMarker(start2, end2);
        String textToInsert = Mover.extractTextToInsert(document, start, end, end2 != document.getTextLength());
        String textToInsert2 = Mover.extractTextToInsert(document, start2, end2, end != document.getTextLength());
        if (range1.getStartOffset() < range2.getStartOffset()) {
            range1.setGreedyToLeft(true);
            range1.setGreedyToRight(false);
            range2.setGreedyToLeft(true);
            range2.setGreedyToRight(true);
        } else {
            range1.setGreedyToLeft(true);
            range1.setGreedyToRight(true);
            range2.setGreedyToLeft(true);
            range2.setGreedyToRight(false);
        }
        CaretModel caretModel = editor.getCaretModel();
        int caretRelativePos = caretModel.getOffset() - start;
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        boolean hasSelection = selectionModel.hasSelection();
        caretModel.moveToOffset(0);
        document.replaceString(range1.getStartOffset(), range1.getEndOffset(), (CharSequence)textToInsert2);
        document.replaceString(range2.getStartOffset(), range2.getEndOffset(), (CharSequence)textToInsert);
        Project project = file.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (hasSelection) {
            Mover.restoreSelection(editor, selectionStart, selectionEnd, start, range2.getStartOffset());
        }
        caretModel.moveToOffset(range2.getStartOffset() + caretRelativePos);
        Mover.reindentLines(document, project, range1, range2);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private static void reindentLines(Document document, Project project, RangeMarker range1, RangeMarker range2) {
        ArrayList<Integer> lines2Reformat = new ArrayList<Integer>();
        if (range1.isValid()) {
            lines2Reformat.add(document.getLineNumber(range1.getStartOffset()));
            lines2Reformat.add(document.getLineNumber(range1.getEndOffset()));
        }
        if (range2.isValid()) {
            lines2Reformat.add(document.getLineNumber(range2.getStartOffset()));
            lines2Reformat.add(document.getLineNumber(range2.getEndOffset()));
        }
        Collections.sort(lines2Reformat);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        for (Integer lineNumber : lines2Reformat) {
            if (lineNumber >= document.getLineCount()) continue;
            codeStyleManager.adjustLineIndent(document, document.getLineStartOffset(lineNumber.intValue()));
        }
    }

    private static String extractTextToInsert(Document document, int start, int end, boolean mayEndWithNewline) {
        String textToInsert = ((Object)document.getCharsSequence().subSequence(start, end)).toString();
        if (!StringUtil.endsWithChar((CharSequence)textToInsert, (char)'\n')) {
            if (mayEndWithNewline) {
                return textToInsert + '\n';
            }
        } else if (!mayEndWithNewline) {
            return StringUtil.trimEnd((String)textToInsert, (String)"\n");
        }
        return textToInsert;
    }

    protected static int getLineStartSafeOffset(Document document, int line) {
        if (line >= document.getLineCount()) {
            return document.getTextLength();
        }
        return document.getLineStartOffset(line);
    }

    private static void restoreSelection(Editor editor, int selectionStart, int selectionEnd, int moveOffset, int insOffset) {
        int selectionRelativeOffset = selectionStart - moveOffset;
        int newSelectionStart = insOffset + selectionRelativeOffset;
        int newSelectionEnd = newSelectionStart + selectionEnd - selectionStart;
        editor.getSelectionModel().setSelection(newSelectionStart, newSelectionEnd);
    }
}

