/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.ConditionalExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class BranchStatement
implements GroovyElementTypes {
    public static TokenSet BRANCH_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{kRETURN, kBREAK, kCONTINUE, kTHROW, kRETURN, kASSERT});

    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        if (kTHROW.equals(builder.getTokenType())) {
            BranchStatement.throwParse(builder, parser);
            return true;
        }
        if (kASSERT.equals(builder.getTokenType())) {
            BranchStatement.assertParse(builder, parser);
            return true;
        }
        if (kRETURN.equals(builder.getTokenType())) {
            BranchStatement.returnParse(builder, parser);
            return true;
        }
        if (kBREAK.equals(builder.getTokenType()) || kCONTINUE.equals(builder.getTokenType())) {
            BranchStatement.breakOrContinueParse(builder);
            return true;
        }
        return false;
    }

    private static void returnParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, kRETURN);
        AssignmentExpression.parse(builder, parser);
        marker.done((IElementType)RETURN_STATEMENT);
    }

    private static void throwParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, kTHROW);
        if (!AssignmentExpression.parse(builder, parser)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        marker.done((IElementType)THROW_STATEMENT);
    }

    private static void assertParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, kASSERT);
        if (!ConditionalExpression.parse(builder, parser)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        if (mCOLON.equals(builder.getTokenType()) || mCOMMA.equals(builder.getTokenType())) {
            builder.advanceLexer();
            if (!AssignmentExpression.parse(builder, parser)) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            }
        }
        marker.done((IElementType)ASSERT_STATEMENT);
    }

    private static void breakOrContinueParse(PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        GroovyElementType result = kBREAK.equals(builder.getTokenType()) ? BREAK_STATEMENT : CONTINUE_STATEMENT;
        builder.advanceLexer();
        ParserUtils.getToken(builder, mIDENT);
        marker.done((IElementType)result);
    }
}

