/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers.Modifiers;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration.Declaration;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.StrictContextExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic.ShiftExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ForStatement
implements GroovyElementTypes {
    public static boolean forClauseParse(PsiBuilder builder, GroovyParser parser) {
        ParserUtils.getToken(builder, mNLS);
        return ForStatement.forInClauseParse(builder, parser) || ForStatement.tradForClauseParse(builder, parser);
    }

    private static boolean tradForClauseParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (ParserUtils.getToken(builder, mSEMI) || Declaration.parse(builder, false, parser) && ParserUtils.getToken(builder, mSEMI)) {
            StrictContextExpression.parse(builder, parser);
            ParserUtils.getToken(builder, mSEMI, GroovyBundle.message("semi.expected", new Object[0]));
            ParserUtils.getToken(builder, mNLS);
            if (!mRPAREN.equals(builder.getTokenType())) {
                ForStatement.controlExpressionListParse(builder, parser);
            }
        } else {
            marker.rollbackTo();
            marker = builder.mark();
            ForStatement.controlExpressionListParse(builder, parser);
            ParserUtils.getToken(builder, mSEMI, GroovyBundle.message("semi.expected", new Object[0]));
            StrictContextExpression.parse(builder, parser);
            ParserUtils.getToken(builder, mSEMI, GroovyBundle.message("semi.expected", new Object[0]));
            ParserUtils.getToken(builder, mNLS);
            if (!mRPAREN.equals(builder.getTokenType())) {
                ForStatement.controlExpressionListParse(builder, parser);
            }
        }
        marker.done((IElementType)FOR_TRADITIONAL_CLAUSE);
        return true;
    }

    private static void controlExpressionListParse(PsiBuilder builder, GroovyParser parser) {
        if (!StrictContextExpression.parse(builder, parser)) {
            return;
        }
        while (mCOMMA.equals(builder.getTokenType())) {
            if (ParserUtils.lookAhead(builder, mCOMMA, mNLS, mRPAREN) || ParserUtils.lookAhead(builder, mCOMMA, mRPAREN)) {
                ParserUtils.getToken(builder, mCOMMA);
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            } else {
                ParserUtils.getToken(builder, mCOMMA);
            }
            ParserUtils.getToken(builder, mNLS);
            if (StrictContextExpression.parse(builder, parser)) continue;
            ParserUtils.getToken(builder, mNLS);
            if (!mRPAREN.equals(builder.getTokenType()) && !mSEMI.equals(builder.getTokenType())) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            }
            if (mRPAREN.equals(builder.getTokenType()) || mSEMI.equals(builder.getTokenType()) || mCOMMA.equals(builder.getTokenType()) || mNLS.equals(builder.getTokenType())) continue;
            builder.advanceLexer();
        }
    }

    private static boolean forInClauseParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        PsiBuilder.Marker paramMarker = builder.mark();
        Modifiers.parse(builder, parser);
        boolean isBuiltInType = TokenSets.BUILT_IN_TYPE.contains(builder.getTokenType());
        PsiBuilder.Marker typeSpec = builder.mark();
        TypeSpec.parseStrict(builder);
        if (builder.getTokenType() == mIDENT || isBuiltInType) {
            typeSpec.drop();
        } else {
            typeSpec.rollbackTo();
        }
        if (TokenSets.FOR_IN_DELIMITERS.contains(builder.getTokenType())) {
            builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
            paramMarker.drop();
        } else if (builder.getTokenType() == mIDENT) {
            ParserUtils.getToken(builder, mIDENT);
            paramMarker.done((IElementType)PARAMETER);
        } else {
            paramMarker.drop();
            marker.rollbackTo();
            return false;
        }
        if (!ParserUtils.getToken(builder, kIN) && !ParserUtils.getToken(builder, mCOLON)) {
            marker.rollbackTo();
            return false;
        }
        if (!ShiftExpression.parse(builder, parser)) {
            builder.error(GroovyBundle.message("expression.expected", new Object[0]));
        }
        marker.done((IElementType)FOR_IN_CLAUSE);
        return true;
    }
}

