/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members.GrMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrMethodStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.impl.GrMethodStubImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrMethodNameIndex;

public class GrMethodElementType
extends GrStubElementType<GrMethodStub, GrMethod> {
    public GrMethodElementType() {
        super("method definition");
    }

    @Override
    public GrMethod createElement(ASTNode node) {
        return new GrMethodImpl(node);
    }

    public GrMethod createPsi(GrMethodStub stub) {
        return new GrMethodImpl(stub);
    }

    public GrMethodStub createStub(GrMethod psi, StubElement parentStub) {
        GrModifierList modifiers = psi.getModifierList();
        Object[] annotations = modifiers.getAnnotations();
        String[] annNames = (String[])ContainerUtil.map((Object[])annotations, (Function)new Function<GrAnnotation, String>(){

            @Nullable
            public String fun(GrAnnotation grAnnotation) {
                GrCodeReferenceElement element = grAnnotation.getClassReference();
                if (element == null) {
                    return null;
                }
                return element.getReferenceName();
            }
        }, (Object[])new String[annotations.length]);
        Set<String>[] namedParametersArray = psi.getNamedParametersArray();
        return new GrMethodStubImpl(parentStub, StringRef.fromString((String)psi.getName()), annNames, namedParametersArray);
    }

    public void serialize(GrMethodStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        String[] annotations = stub.getAnnotations();
        dataStream.writeByte(annotations.length);
        for (String s : annotations) {
            dataStream.writeName(s);
        }
        Set<String>[] namedParameters = stub.getNamedParameters();
        GrStubUtils.serializeCollectionsArray(dataStream, namedParameters);
    }

    public GrMethodStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef ref = dataStream.readName();
        int b = dataStream.readByte();
        String[] annNames = new String[b];
        for (int i = 0; i < b; ++i) {
            annNames[i] = dataStream.readName().toString();
        }
        List<Set<String>> namedParametersSets = GrStubUtils.deserializeCollectionsArray(dataStream);
        return new GrMethodStubImpl(parentStub, ref, annNames, namedParametersSets.toArray(new HashSet[0]));
    }

    @Override
    public void indexStub(GrMethodStub stub, IndexSink sink) {
        String name = stub.getName();
        if (name != null) {
            sink.occurrence(GrMethodNameIndex.KEY, (Object)name);
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }
}

