/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.impl.GrTypeDefinitionStubImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnonymousClassIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrFullClassNameIndex;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrShortClassNameIndex;

public abstract class GrTypeDefinitionElementType<TypeDef extends GrTypeDefinition>
extends GrStubElementType<GrTypeDefinitionStub, TypeDef> {
    public GrTypeDefinitionElementType(@NotNull String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrTypeDefinitionElementType.<init> must not be null");
        }
        super(debugName);
    }

    public GrTypeDefinitionStub createStub(TypeDef psi, StubElement parentStub) {
        String[] superClassNames = psi.getSuperClassNames();
        byte flags = GrTypeDefinitionStubImpl.buildFlags(psi);
        return new GrTypeDefinitionStubImpl(parentStub, psi.getName(), superClassNames, this, psi.getQualifiedName(), GrTypeDefinitionElementType.getAnnotationNames(psi), flags);
    }

    private static String[] getAnnotationNames(GrTypeDefinition psi) {
        ArrayList annoNames = CollectionFactory.arrayList();
        GrModifierList modifierList = psi.getModifierList();
        if (modifierList instanceof GrModifierList) {
            for (GrAnnotation annotation : modifierList.getAnnotations()) {
                String annoShortName;
                GrCodeReferenceElement element = annotation.getClassReference();
                if (element == null || !StringUtil.isNotEmpty((String)(annoShortName = StringUtil.getShortName((String)element.getText()).trim()))) continue;
                annoNames.add(annoShortName);
            }
        }
        return ArrayUtil.toStringArray((Collection)annoNames);
    }

    public void serialize(GrTypeDefinitionStub stub, StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getQualifiedName());
        dataStream.writeByte((int)stub.getFlags());
        GrTypeDefinitionElementType.writeStringArray(dataStream, stub.getSuperClassNames());
        GrTypeDefinitionElementType.writeStringArray(dataStream, stub.getAnnotations());
    }

    private static void writeStringArray(StubOutputStream dataStream, String[] names) throws IOException {
        dataStream.writeByte(names.length);
        for (String name : names) {
            dataStream.writeName(name);
        }
    }

    public GrTypeDefinitionStub deserialize(StubInputStream dataStream, StubElement parentStub) throws IOException {
        String name = StringRef.toString((StringRef)dataStream.readName());
        String qname = StringRef.toString((StringRef)dataStream.readName());
        byte flags = dataStream.readByte();
        String[] superClasses = GrTypeDefinitionElementType.readStringArray(dataStream);
        String[] annos = GrTypeDefinitionElementType.readStringArray(dataStream);
        return new GrTypeDefinitionStubImpl(parentStub, name, superClasses, this, qname, annos, flags);
    }

    private static String[] readStringArray(StubInputStream dataStream) throws IOException {
        int supersNumber = dataStream.readByte();
        String[] superClasses = new String[supersNumber];
        for (int i = 0; i < supersNumber; ++i) {
            superClasses[i] = StringRef.toString((StringRef)dataStream.readName());
        }
        return superClasses;
    }

    @Override
    public void indexStub(GrTypeDefinitionStub stub, IndexSink sink) {
        if (stub.isAnonymous()) {
            String[] classNames = stub.getSuperClassNames();
            if (classNames.length != 1) {
                return;
            }
            String baseClassName = classNames[0];
            if (baseClassName != null) {
                String shortName = PsiNameHelper.getShortClassName((String)baseClassName);
                sink.occurrence(GrAnonymousClassIndex.KEY, (Object)shortName);
            }
        } else {
            String fqn;
            String shortName = stub.getName();
            if (shortName != null) {
                sink.occurrence(GrShortClassNameIndex.KEY, (Object)shortName);
            }
            if ((fqn = stub.getQualifiedName()) != null) {
                sink.occurrence(GrFullClassNameIndex.KEY, (Object)fqn.hashCode());
            }
        }
        for (String annName : stub.getAnnotations()) {
            if (annName == null) continue;
            sink.occurrence(GrAnnotatedMemberIndex.KEY, (Object)annName);
        }
    }
}

