/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.overrideImplement;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsParameterImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTopLevelDefintion;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyOverrideImplementUtil {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.overrideImplement.GroovyOverrideImplementUtil");
    private static final String[] GROOVY_MODIFIERS = new String[]{"public", "protected", "private", "static", "abstract", "final", "synchronized"};

    private GroovyOverrideImplementUtil() {
    }

    public static void invokeOverrideImplement(final Project project, final Editor editor, final PsiFile file, boolean isImplement) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement parent = file.findElementAt(offset);
        if (parent == null) {
            return;
        }
        while (!(parent instanceof GrTypeDefinition)) {
            if ((parent = parent.getParent()) != null) continue;
            return;
        }
        final GrTypeDefinition aClass = (GrTypeDefinition)parent;
        if (isImplement && aClass.isInterface()) {
            return;
        }
        Collection<CandidateInfo> candidates = GroovyOverrideImplementUtil.getMethodsToOverrideImplement(aClass, isImplement);
        if (candidates.isEmpty()) {
            return;
        }
        ArrayList<PsiMethodMember> classMembers = new ArrayList<PsiMethodMember>();
        for (CandidateInfo candidate : candidates) {
            PsiMethod method = (PsiMethod)candidate.getElement();
            assert (method != null);
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || "groovy.lang.GroovyObject".equals(containingClass.getQualifiedName())) continue;
            classMembers.add(new PsiMethodMember(candidate));
        }
        MemberChooser chooser = new MemberChooser((ClassMember[])classMembers.toArray(new PsiMethodMember[classMembers.size()]), false, true, project);
        chooser.setTitle(isImplement ? GroovyBundle.message("select.methods.to.implement", new Object[0]) : GroovyBundle.message("select.methods.to.override", new Object[0]));
        chooser.show();
        List selectedElements = chooser.getSelectedElements();
        if (selectedElements == null || selectedElements.size() == 0) {
            return;
        }
        for (PsiMethodMember methodMember : selectedElements) {
            final PsiMethod method = (PsiMethod)methodMember.getElement();
            final PsiSubstitutor substitutor = methodMember.getSubstitutor();
            boolean isAbstract = method.hasModifierProperty("abstract");
            String templName = isAbstract ? "Implemented Method Body.java" : "Overridden Method Body.java";
            final FileTemplate template = FileTemplateManager.getInstance().getCodeTemplate(templName);
            final GrMethod result = GroovyOverrideImplementUtil.createOverrideImplementMethodSignature(project, method, substitutor, aClass);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        GrModifierList modifierList = result.getModifierList();
                        modifierList.setModifierProperty("abstract", false);
                        modifierList.setModifierProperty("native", false);
                        GroovyOverrideImplementUtil.setupOverridingMethodBody(project, method, result, template, substitutor);
                        GrTypeDefinitionBody classBody = aClass.getBody();
                        PsiMethod[] methods = aClass.getMethods();
                        PsiElement anchor = null;
                        int caretPosition = editor.getCaretModel().getOffset();
                        PsiElement thisCaretPsiElement = file.findElementAt(caretPosition);
                        GrTopLevelDefintion previousTopLevelElement = PsiUtil.findPreviousTopLevelElementByThisElement(thisCaretPsiElement);
                        if (thisCaretPsiElement != null && thisCaretPsiElement.getParent() instanceof GrTypeDefinitionBody) {
                            anchor = GroovyTokenTypes.mLCURLY.equals(thisCaretPsiElement.getNode().getElementType()) ? thisCaretPsiElement.getNextSibling() : (GroovyTokenTypes.mRCURLY.equals(thisCaretPsiElement.getNode().getElementType()) ? thisCaretPsiElement.getPrevSibling() : thisCaretPsiElement);
                        } else if (previousTopLevelElement != null && previousTopLevelElement instanceof GrMethod) {
                            PsiElement nextElement = previousTopLevelElement.getNextSibling();
                            if (nextElement != null) {
                                anchor = nextElement;
                            }
                        } else if (methods.length != 0) {
                            PsiElement nextSibling;
                            PsiMethod lastMethod = methods[methods.length - 1];
                            if (lastMethod != null && (nextSibling = lastMethod.getNextSibling()) != null) {
                                anchor = nextSibling;
                            }
                        } else {
                            PsiElement firstChild = classBody.getFirstChild();
                            assert (firstChild != null);
                            PsiElement nextElement = firstChild.getNextSibling();
                            assert (nextElement != null);
                            anchor = nextElement;
                        }
                        GrMethod addedMethod = (GrMethod)aClass.addMemberDeclaration(result, anchor);
                        PsiUtil.shortenReferences(addedMethod);
                        GroovyOverrideImplementUtil.positionCaret(editor, addedMethod);
                    }
                    catch (IncorrectOperationException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    public static Collection<CandidateInfo> getMethodsToOverrideImplement(GrTypeDefinition aClass, boolean isImplement) {
        return OverrideImplementUtil.getMethodsToOverrideImplement((PsiClass)aClass, (boolean)isImplement);
    }

    private static void positionCaret(Editor editor, GrMethod result) {
        GrOpenBlock body = result.getBlock();
        if (body == null) {
            return;
        }
        PsiElement lBrace = body.getLBrace();
        assert (lBrace != null);
        PsiElement l = lBrace.getNextSibling();
        assert (l != null);
        PsiElement rBrace = body.getRBrace();
        assert (rBrace != null);
        PsiElement r = rBrace.getPrevSibling();
        assert (r != null);
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)result.getProject()).isUncommited(editor.getDocument()));
        String text = editor.getDocument().getText();
        int start = l.getTextRange().getStartOffset();
        start = CharArrayUtil.shiftForward((CharSequence)text, (int)start, (String)"\n\t ");
        int end = r.getTextRange().getEndOffset();
        end = CharArrayUtil.shiftBackward((CharSequence)text, (int)(end - 1), (String)"\n\t ") + 1;
        editor.getCaretModel().moveToOffset(Math.min(start, end));
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        if (start < end) {
            editor.getSelectionModel().setSelection(start, end);
        }
    }

    private static boolean writeMethodModifiers(StringBuffer text, PsiModifierList modifierList, String[] modifiers) {
        boolean wasAddedModifiers = false;
        for (String modifierType : modifiers) {
            if (!modifierList.hasModifierProperty(modifierType) || modifierType == "public") continue;
            text.append(modifierType);
            text.append(" ");
            wasAddedModifiers = true;
        }
        return wasAddedModifiers;
    }

    private static GrMethod createOverrideImplementMethodSignature(Project project, PsiMethod method, PsiSubstitutor substitutor, PsiClass aClass) {
        StringBuffer buffer = new StringBuffer();
        if (!GroovyOverrideImplementUtil.writeMethodModifiers(buffer, method.getModifierList(), GROOVY_MODIFIERS)) {
            buffer.append("def ");
        }
        PsiType returnType = substitutor.substitute(method.getReturnType());
        if (method.isConstructor()) {
            buffer.append(aClass.getName());
        } else {
            if (returnType != null) {
                buffer.append(returnType.getCanonicalText());
                buffer.append(" ");
            }
            buffer.append(method.getName());
        }
        buffer.append(" ");
        buffer.append("(");
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            PsiParameter parameter = parameters[i];
            PsiType parameterType = substitutor.substitute(parameter.getType());
            buffer.append(parameterType.getCanonicalText());
            buffer.append(" ");
            String paramName = parameter.getName();
            if (paramName != null) {
                buffer.append(paramName);
                continue;
            }
            if (!(parameter instanceof ClsParameterImpl)) continue;
            ClsParameterImpl clsParameter = (ClsParameterImpl)parameter;
            buffer.append(((PsiParameter)clsParameter.getMirror()).getName());
        }
        buffer.append(")");
        buffer.append(" ");
        buffer.append("{");
        buffer.append("}");
        return (GrMethod)GroovyPsiElementFactory.getInstance(project).createTopElementFromText(buffer.toString());
    }

    private static void setupOverridingMethodBody(Project project, PsiMethod method, GrMethod resultMethod, FileTemplate template, PsiSubstitutor substitutor) {
        PsiType returnType = substitutor.substitute(method.getReturnType());
        String returnTypeText = "";
        if (returnType != null) {
            returnTypeText = returnType.getPresentableText();
        }
        Properties properties = new Properties();
        properties.setProperty("RETURN_TYPE", returnTypeText);
        properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)returnType));
        properties.setProperty("CALL_SUPER", GroovyOverrideImplementUtil.callSuper(method, resultMethod));
        JavaTemplateUtil.setClassAndMethodNameProperties((Properties)properties, (PsiClass)method.getContainingClass(), (PsiMethod)resultMethod);
        try {
            String bodyText = template.getText(properties);
            GrCodeBlock newBody = GroovyPsiElementFactory.getInstance(project).createMethodBodyFromText("\n" + bodyText + "\n");
            resultMethod.setBlock(newBody);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private static String callSuper(PsiMethod superMethod, PsiMethod overriding) {
        StringBuilder buffer = new StringBuilder();
        if (!superMethod.isConstructor() && superMethod.getReturnType() != PsiType.VOID) {
            buffer.append("return ");
        }
        buffer.append("super");
        PsiParameter[] parms = overriding.getParameterList().getParameters();
        if (!superMethod.isConstructor()) {
            buffer.append(".");
            buffer.append(superMethod.getName());
        }
        buffer.append("(");
        for (int i = 0; i < parms.length; ++i) {
            String name = parms[i].getName();
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(name);
        }
        buffer.append(")");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/overrideImplement/GroovyOverrideImplementUtil.callSuper must not return null");
        }
        return string;
    }

    public static Collection<CandidateInfo> getMethodsToImplement(PsiClass typeDefinition) {
        Collection methodsToImplement = OverrideImplementUtil.getMethodsToOverrideImplement((PsiClass)typeDefinition, (boolean)true);
        methodsToImplement = ContainerUtil.findAll((Collection)methodsToImplement, (Condition)new Condition<CandidateInfo>(){

            public boolean value(CandidateInfo candidateInfo) {
                return !"groovy.lang.GroovyObject".equals(((PsiMethod)candidateInfo.getElement()).getContainingClass().getQualifiedName());
            }
        });
        return methodsToImplement;
    }
}

