/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.plugins.groovy.refactoring.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ExtractMethodInfoHelper;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.GroovyExtractMethodDialog;
import org.jetbrains.plugins.groovy.refactoring.extractMethod.ParameterInfo;

public class ParameterTablePanel
extends JPanel {
    private Project myProject;
    private ParameterInfo[] myParameterInfos;
    private TypeSelector[] myParameterTypeSelectors;
    private GroovyExtractMethodDialog myDialog;
    private Table myTable;
    private MyTableModel myTableModel;
    private JButton myUpButton;
    private JButton myDownButton;
    private JComboBox myTypeRendererCombo;

    public ParameterTablePanel() {
        super(new BorderLayout());
    }

    void init(GroovyExtractMethodDialog dialog, ExtractMethodInfoHelper helper) {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), GroovyRefactoringBundle.message("parameters.border.title", new Object[0])));
        this.myDialog = dialog;
        this.myProject = helper.getProject();
        this.myParameterInfos = helper.getParameterInfos();
        this.myTableModel = new MyTableModel();
        this.myTable = new Table((TableModel)this.myTableModel);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.setTableHeader(null);
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new CheckBoxTableCellRenderer()));
        this.myTable.getColumnModel().getColumn(0).setMaxWidth(new JCheckBox().getPreferredSize().width);
        this.myTable.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                ParameterInfo info = ParameterTablePanel.this.myParameterInfos[row];
                this.setText(info.getName());
                return this;
            }
        });
        PsiManager manager = PsiManager.getInstance((Project)this.myProject);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        this.myParameterTypeSelectors = new TypeSelector[this.myParameterInfos.length];
        for (int i = 0; i < this.myParameterTypeSelectors.length; ++i) {
            PsiType type = this.myParameterInfos[i].getType();
            this.myParameterTypeSelectors[i] = new TypeSelector((PsiType)(type != null ? type : PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope)));
        }
        this.myTypeRendererCombo = new JComboBox<ParameterInfo>(this.myParameterInfos);
        this.myTypeRendererCombo.setOpaque(true);
        this.myTypeRendererCombo.setBorder(null);
        this.myTypeRendererCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                PsiType type = ((ParameterInfo)value).getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
                type = unboxed != null ? unboxed : type;
                this.setText(type != null ? type.getPresentableText() : "");
                return this;
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellEditor((TableCellEditor)new AbstractTableCellEditor(){
            TypeSelector myCurrentSelector;

            public Object getCellEditorValue() {
                return this.myCurrentSelector.getSelectedType();
            }

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.myCurrentSelector = ParameterTablePanel.this.myParameterTypeSelectors[row];
                return this.myCurrentSelector.getComponent();
            }
        });
        this.myTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (ParameterTablePanel.this.myParameterTypeSelectors[row].getComponent() instanceof JComboBox) {
                    ParameterTablePanel.this.myTypeRendererCombo.setSelectedIndex(row);
                    return ParameterTablePanel.this.myTypeRendererCombo;
                }
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                ParameterInfo info = ParameterTablePanel.this.myParameterInfos[row];
                PsiType type = info.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
                type = unboxed != null ? unboxed : type;
                this.setText(type != null ? type.getPresentableText() : "");
                return this;
            }
        });
        this.myTable.setPreferredScrollableViewportSize(new Dimension(250, this.myTable.getRowHeight() * 5));
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParameterTablePanel.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = ParameterTablePanel.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (ParameterTablePanel.this.myParameterInfos[row].passAsParameter()) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        ParameterTablePanel.this.myParameterInfos[row].setPassAsParameter(valueToBeSet);
                    }
                    ParameterTablePanel.this.myTableModel.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
                    TableUtil.selectRows((JTable)ParameterTablePanel.this.myTable, (int[])rows);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "edit_parameter_name");
        actionMap.put("edit_parameter_name", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ParameterTablePanel.this.myTable.isEditing() && (row = ParameterTablePanel.this.myTable.getSelectedRow()) >= 0 && row < ParameterTablePanel.this.myTableModel.getRowCount()) {
                    TableUtil.editCellAt((JTable)ParameterTablePanel.this.myTable, (int)row, (int)2);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "invokeImpl");
        actionMap.put("invokeImpl", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = ParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    ParameterTablePanel.this.doEnterAction();
                }
            }
        });
        actionMap.put("doCancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor editor = ParameterTablePanel.this.myTable.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                } else {
                    ParameterTablePanel.this.doCancelAction();
                }
            }
        });
        JPanel listPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myTable);
        listPanel.add((Component)scrollPane, "Center");
        listPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)listPanel, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.add((Component)buttonsPanel, "East");
        buttonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.insets = new Insets(2, 4, 2, 4);
        this.myUpButton = new JButton();
        this.myUpButton.setText(GroovyRefactoringBundle.message("row.move.up", new Object[0]));
        this.myUpButton.setDefaultCapable(false);
        this.myUpButton.setMnemonic(85);
        buttonsPanel.add((Component)this.myUpButton, gbConstraints);
        this.myDownButton = new JButton();
        this.myDownButton.setText(GroovyRefactoringBundle.message("row.move.down", new Object[0]));
        this.myDownButton.setMnemonic(68);
        this.myDownButton.setDefaultCapable(false);
        buttonsPanel.add((Component)this.myDownButton, gbConstraints);
        gbConstraints.weighty = 1.0;
        buttonsPanel.add((Component)new JPanel(), gbConstraints);
        this.myUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isStopped;
                if (ParameterTablePanel.this.myTable.isEditing() && !(isStopped = ParameterTablePanel.this.myTable.getCellEditor().stopCellEditing())) {
                    return;
                }
                ParameterTablePanel.this.moveSelectedItem(-1);
                ParameterTablePanel.this.updateSignature();
                ParameterTablePanel.this.myTable.requestFocus();
            }
        });
        this.myDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isStopped;
                if (ParameterTablePanel.this.myTable.isEditing() && !(isStopped = ParameterTablePanel.this.myTable.getCellEditor().stopCellEditing())) {
                    return;
                }
                ParameterTablePanel.this.moveSelectedItem(1);
                ParameterTablePanel.this.updateSignature();
                ParameterTablePanel.this.myTable.requestFocus();
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ParameterTablePanel.this.updateMoveButtons();
            }
        });
        if (this.myParameterInfos.length <= 1) {
            this.myUpButton.setEnabled(false);
            this.myDownButton.setEnabled(false);
        } else {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.updateMoveButtons();
    }

    private void updateMoveButtons() {
        int row = this.myTable.getSelectedRow();
        if (0 <= row && row < this.myParameterInfos.length) {
            this.myUpButton.setEnabled(row > 0);
            this.myDownButton.setEnabled(row < this.myParameterInfos.length - 1);
        } else {
            this.myUpButton.setEnabled(false);
            this.myDownButton.setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTable.setEnabled(enabled);
        if (!enabled) {
            this.myUpButton.setEnabled(false);
            this.myDownButton.setEnabled(false);
        } else {
            this.updateMoveButtons();
        }
        super.setEnabled(enabled);
    }

    private void moveSelectedItem(int moveIncrement) {
        int row = this.myTable.getSelectedRow();
        if (row < 0 || row >= this.myParameterInfos.length) {
            return;
        }
        int targetRow = row + moveIncrement;
        if (targetRow < 0 || targetRow >= this.myParameterInfos.length) {
            return;
        }
        ParameterInfo currentItem = this.myParameterInfos[row];
        int currentPosition = currentItem.getPosition();
        ParameterInfo targetItem = this.myParameterInfos[targetRow];
        currentItem.setPosition(targetItem.getPosition());
        targetItem.setPosition(currentPosition);
        this.myParameterInfos[row] = targetItem;
        this.myParameterInfos[targetRow] = currentItem;
        TypeSelector currentSelector = this.myParameterTypeSelectors[row];
        this.myParameterTypeSelectors[row] = this.myParameterTypeSelectors[targetRow];
        this.myParameterTypeSelectors[targetRow] = currentSelector;
        this.myTypeRendererCombo.setModel(new DefaultComboBoxModel<ParameterInfo>(this.myParameterInfos));
        this.myTableModel.fireTableRowsUpdated(Math.min(targetRow, row), Math.max(targetRow, row));
        this.myTable.getSelectionModel().setSelectionInterval(targetRow, targetRow);
    }

    protected void updateSignature() {
        this.myDialog.updateSignature();
    }

    protected void doEnterAction() {
        this.myDialog.clickDefaultButton();
    }

    protected void doCancelAction() {
        this.myDialog.doCancelAction();
    }

    private class CheckBoxTableCellRenderer
    extends BooleanTableCellRenderer {
        private CheckBoxTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            rendererComponent.setEnabled(ParameterTablePanel.this.isEnabled());
            return rendererComponent;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        public static final int CHECKMARK_COLUMN = 0;
        public static final int PARAMETER_TYPE_COLUMN = 1;
        public static final int PARAMETER_NAME_COLUMN = 2;

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return ParameterTablePanel.this.myParameterInfos.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ParameterTablePanel.this.myParameterInfos[rowIndex].passAsParameter() ? Boolean.TRUE : Boolean.FALSE;
                }
                case 2: {
                    return ParameterTablePanel.this.myParameterInfos[rowIndex].getName();
                }
                case 1: {
                    PsiType type = ParameterTablePanel.this.myParameterInfos[rowIndex].getType();
                    return type != null ? type.getPresentableText() : "";
                }
            }
            assert (false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ParameterTablePanel.this.myParameterInfos[rowIndex].setPassAsParameter((Boolean)aValue);
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    ParameterTablePanel.this.myTable.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
                case 2: {
                    ParameterInfo info = ParameterTablePanel.this.myParameterInfos[rowIndex];
                    String name = (String)aValue;
                    if (GroovyNamesUtil.isIdentifier(name)) {
                        info.setNewName(name);
                    }
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
                case 1: {
                    ParameterInfo info = ParameterTablePanel.this.myParameterInfos[rowIndex];
                    info.setType((PsiType)aValue);
                    ParameterTablePanel.this.updateSignature();
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ParameterTablePanel.this.isEnabled();
                }
                case 2: {
                    return ParameterTablePanel.this.isEnabled() && ParameterTablePanel.this.myParameterInfos[rowIndex].passAsParameter();
                }
                case 1: {
                    return ParameterTablePanel.this.isEnabled() && ParameterTablePanel.this.myParameterInfos[rowIndex].passAsParameter() && !(ParameterTablePanel.this.myParameterTypeSelectors[rowIndex].getComponent() instanceof JLabel);
                }
            }
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }
    }
}

