/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.extractMethod;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;

public class VisibilityPanel
extends JPanel {
    private final JRadioButton myRbPrivate;
    private final JRadioButton myRbProtected;
    private final JRadioButton myRbPublic;

    public VisibilityPanel() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), GroovyRefactoringBundle.message("visibility.border.title", new Object[0])));
        this.setLayout(new BoxLayout(this, 1));
        ButtonGroup bg = new ButtonGroup();
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    VisibilityPanel.this.fireStateChanged();
                }
            }
        };
        this.myRbPrivate = new JRadioButton();
        this.myRbPrivate.setText(GroovyRefactoringBundle.message("visibility.private", new Object[0]));
        this.myRbPrivate.addItemListener(listener);
        this.myRbPrivate.setFocusable(false);
        this.myRbPrivate.setMnemonic(86);
        this.add(this.myRbPrivate);
        bg.add(this.myRbPrivate);
        this.myRbProtected = new JRadioButton();
        this.myRbProtected.setText(GroovyRefactoringBundle.message("visibility.protected", new Object[0]));
        this.myRbProtected.addItemListener(listener);
        this.myRbProtected.setFocusable(false);
        this.myRbProtected.setMnemonic(79);
        this.add(this.myRbProtected);
        bg.add(this.myRbProtected);
        this.myRbPublic = new JRadioButton();
        this.myRbPublic.setText(GroovyRefactoringBundle.message("visibility.public", new Object[0]));
        this.myRbPublic.addItemListener(listener);
        this.myRbPublic.setFocusable(false);
        this.myRbPublic.setMnemonic(66);
        this.add(this.myRbPublic);
        bg.add(this.myRbPublic);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public String getVisibility() {
        if (this.myRbPublic.isSelected()) {
            return "public";
        }
        if (this.myRbProtected.isSelected()) {
            return "protected";
        }
        if (!this.myRbPrivate.isSelected()) return "private";
        return "private";
    }

    public void setVisibilityEnabled(String visibility, boolean value) {
        if ("private".equals(visibility)) {
            this.myRbPrivate.setEnabled(value);
        } else if ("protected".equals(visibility)) {
            this.myRbProtected.setEnabled(value);
        } else if ("public".equals(visibility)) {
            this.myRbPublic.setEnabled(value);
        }
    }

    public void setVisibility(String visibility) {
        if ("public".equals(visibility)) {
            this.myRbPublic.setSelected(true);
        } else if ("protected".equals(visibility)) {
            this.myRbProtected.setSelected(true);
        } else if ("private".equals(visibility)) {
            this.myRbPrivate.setSelected(true);
        }
    }

    public void addStateChangedListener(VisibilityStateChanged l) {
        this.listenerList.add(VisibilityStateChanged.class, l);
    }

    public void fireStateChanged() {
        Object[] list = this.listenerList.getListenerList();
        String visibility = this.getVisibility();
        for (Object obj : list) {
            if (!(obj instanceof VisibilityStateChanged)) continue;
            ((VisibilityStateChanged)obj).visibilityChanged(visibility);
        }
    }

    public static interface VisibilityStateChanged
    extends EventListener {
        public void visibilityChanged(String var1);
    }
}

