/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrClassSubstitution;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyInlineMethodUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyInlineVariableUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyMethodInliner;

public class GroovyInlineHandler
implements InlineHandler {
    private static final String INLINE_REFACTORING = GroovyRefactoringBundle.message("inline.refactoring.title", new Object[0]);

    @Nullable
    public InlineHandler.Settings prepareInlineElement(PsiElement element, Editor editor, boolean invokedOnReference) {
        if (element instanceof GrVariable && GroovyRefactoringUtil.isLocalVariable((GrVariable)element)) {
            return GroovyInlineVariableUtil.inlineLocalVariableSettings((GrVariable)element, editor, invokedOnReference);
        }
        if (element instanceof GrMethod) {
            return GroovyInlineMethodUtil.inlineMethodSettings((GrMethod)element, editor, invokedOnReference);
        }
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode()) {
            String message = GroovyRefactoringBundle.message("wrong.element.to.inline", new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)message, (String)INLINE_REFACTORING, (String)"refactoring.inlineVariable");
        }
        if (element instanceof GrTypeDefinition || element instanceof GrClassSubstitution) {
            return null;
        }
        if (element instanceof PsiMember) {
            return new InlineHandler.Settings(){

                public boolean isOnlyOneReferenceToInline() {
                    return true;
                }
            };
        }
        return null;
    }

    public void removeDefinition(PsiElement element, InlineHandler.Settings settings) {
        PsiElement owner = element.getParent().getParent();
        if (element instanceof GrVariable && owner instanceof GrVariableDeclarationOwner) {
            ((GrVariableDeclarationOwner)owner).removeVariable((GrVariable)element);
        }
        if (element instanceof GrMethod) {
            element.delete();
        }
    }

    @Nullable
    public InlineHandler.Inliner createInliner(PsiElement element, InlineHandler.Settings settings) {
        if (element instanceof GrVariable && GroovyRefactoringUtil.isLocalVariable((GrVariable)element)) {
            return GroovyInlineVariableUtil.createInlinerForLocalVariable((GrVariable)element);
        }
        if (element instanceof GrMethod) {
            return new GroovyMethodInliner((GrMethod)element);
        }
        return null;
    }
}

