/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.actions;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.actions.ActionOnSelectedElement;
import com.intellij.cvsSupport2.actions.cvsContext.CvsContext;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;

public class RestoreFileAction
extends ActionOnSelectedElement {
    protected final VirtualFile myParent;
    private final String myFileName;

    public RestoreFileAction(VirtualFile parent, String fileName) {
        super(true);
        this.getVisibility().shouldNotBePerformedOnDirectory();
        this.myParent = parent;
        this.myFileName = fileName;
    }

    @Override
    protected String getTitle(VcsContext context) {
        return CvsBundle.message((String)"operation.name.restore.file", (Object[])new Object[0]);
    }

    @Override
    protected CvsHandler getCvsHandler(CvsContext context) {
        return CommandCvsHandler.createRestoreFileHandler(this.myParent, this.myFileName, CvsConfiguration.getInstance((Project)context.getProject()).MAKE_NEW_FILES_READONLY);
    }

    @Override
    protected void onActionPerformed(CvsContext context, CvsTabbedWindow tabbedWindow, boolean successfully, CvsHandler handler) {
        List<VcsException> errors = handler.getErrors();
        if (errors == null || errors != null && errors.isEmpty()) {
            CvsEntriesManager.getInstance().clearCachedEntriesFor(this.myParent);
        }
    }
}

