/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsBrowser;

import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.cvsBrowser.Cvs2Renderer;
import com.intellij.cvsSupport2.cvsBrowser.CvsElement;
import com.intellij.cvsSupport2.cvsBrowser.CvsElementFactory;
import com.intellij.cvsSupport2.cvsBrowser.CvsTreeModel;
import com.intellij.cvsSupport2.cvsBrowser.RootDataProvider;
import com.intellij.cvsSupport2.ui.CvsTabbedWindow;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public class CvsTree
extends JPanel
implements CvsTabbedWindow.DeactivateListener {
    private CvsElement[] myCurrentSelection = new CvsElement[0];
    private Tree myTree;
    private final CvsRootConfiguration myCvsRootConfiguration;
    private final Observable mySelectionObservable = new AlwaysNotificatedObservable();
    private final boolean myShowFiles;
    private final boolean myAllowRootSelection;
    private final boolean myShowModules;
    private final Project myProject;
    private final int mySelectionModel;
    @NonNls
    public static final String SELECTION_CHANGED = "Selection Changed";
    @NonNls
    public static final String LOGIN_ABORTED = "Login Aborted";
    private final List<CvsTabbedWindow.DeactivateListener> myListeners = new ArrayList<CvsTabbedWindow.DeactivateListener>();

    public CvsTree(CvsRootConfiguration env, Project project, boolean showFiles, int selectionMode, boolean allowRootSelection, boolean showModules) {
        super(new BorderLayout());
        this.myProject = project;
        this.mySelectionModel = selectionMode;
        this.myShowModules = showModules;
        this.myAllowRootSelection = allowRootSelection;
        this.myShowFiles = showFiles;
        this.setSize(500, 500);
        this.myCvsRootConfiguration = env;
    }

    private void addSelectionListener() {
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CvsTree.this.setCurrentSelection(CvsTree.this.myTree.getSelectionPaths());
            }
        });
    }

    private void setCurrentSelection(TreePath[] paths) {
        ArrayList<CvsElement> selection = new ArrayList<CvsElement>();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                CvsElement cvsElement;
                Object selectedObject = paths[i].getLastPathComponent();
                if (!(selectedObject instanceof CvsElement) || (cvsElement = (CvsElement)selectedObject).getElementPath().equals(".") && !this.myAllowRootSelection) continue;
                selection.add(cvsElement);
            }
        }
        this.myCurrentSelection = selection.toArray(new CvsElement[selection.size()]);
        this.mySelectionObservable.notifyObservers(SELECTION_CHANGED);
    }

    private CvsElement createRoot(Project project) {
        String rootName = this.myCvsRootConfiguration.toString();
        CvsElement result = CvsElementFactory.FOLDER_ELEMENT_FACTORY.createElement(rootName, this.myCvsRootConfiguration, project);
        result.setName(rootName);
        result.setDataProvider(new RootDataProvider(this.myCvsRootConfiguration, this.myShowFiles, this.myShowModules));
        result.setPath(".");
        result.cannotBeCheckedOut();
        return result;
    }

    public CvsElement[] getCurrentSelection() {
        return this.myCurrentSelection;
    }

    public void addSelectionObserver(Observer observer) {
        this.mySelectionObservable.addObserver(observer);
    }

    public JTree getTree() {
        return this.myTree;
    }

    public void dispose() {
        this.mySelectionObservable.deleteObservers();
    }

    public void onLoginAborted() {
        this.mySelectionObservable.notifyObservers(LOGIN_ABORTED);
    }

    public void init() {
        CvsElement root = this.createRoot(this.myProject);
        DefaultTreeModel deafModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        CvsTreeModel model = new CvsTreeModel(root);
        root.setModel(model);
        this.myTree = new Tree((TreeModel)deafModel);
        model.setTree((JTree)this.myTree);
        model.setCvsTree(this);
        this.add((Component)new JScrollPane((Component)this.myTree), "Center");
        this.myTree.setModel((TreeModel)model);
        this.myTree.getSelectionModel().setSelectionMode(this.mySelectionModel);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new Cvs2Renderer()));
        this.addSelectionListener();
        TreeUIHelper uiHelper = TreeUIHelper.getInstance();
        uiHelper.installToolTipHandler((JTree)this.myTree);
        uiHelper.installTreeSpeedSearch((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CvsTabbedWindow.DeactivateListener listener) {
        List<CvsTabbedWindow.DeactivateListener> list = this.myListeners;
        synchronized (list) {
            if (!this.myListeners.contains(listener)) {
                this.myListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(CvsTabbedWindow.DeactivateListener listener) {
        List<CvsTabbedWindow.DeactivateListener> list = this.myListeners;
        synchronized (list) {
            this.myListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivated() {
        List<CvsTabbedWindow.DeactivateListener> list = this.myListeners;
        synchronized (list) {
            for (CvsTabbedWindow.DeactivateListener listener : this.myListeners) {
                listener.deactivated();
            }
            this.myListeners.clear();
        }
    }

    class AlwaysNotificatedObservable
    extends Observable {
        AlwaysNotificatedObservable() {
        }

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    }
}

