/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.util.PatternUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class CvsMessagePattern {
    private final Pattern myPattern;
    private final int myFileNameGroup;

    public CvsMessagePattern(@NonNls String[] groups, int fileNameGroup) {
        this.myFileNameGroup = fileNameGroup;
        String regex = this.createRegex(groups);
        this.myPattern = Pattern.compile(regex);
    }

    private String createRegex(@NonNls String[] groups) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < groups.length; ++i) {
            String group = groups[i];
            result.append("(");
            result.append(PatternUtil.convertToRegex((String)group));
            result.append(")");
        }
        return result.toString();
    }

    public boolean matches(String string) {
        return this.myPattern.matcher(string).matches();
    }

    public CvsMessagePattern(String[] pattern) {
        this(pattern, -1);
    }

    public CvsMessagePattern(@NonNls String pattern) {
        this(new String[]{pattern});
    }

    public String getRelativeFileName(String message) {
        if (this.myFileNameGroup < 0) {
            return null;
        }
        Matcher matcher = this.myPattern.matcher(message);
        if (matcher.matches()) {
            return matcher.group(this.myFileNameGroup);
        }
        return null;
    }
}

