/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsAdd.ui;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddedFileInfo;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.ui.AbstractAddOptionsDialog;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.ui.AddedFileCellRenderer;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;
import com.intellij.cvsSupport2.ui.Options;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ComboBoxTableCellEditor;
import com.intellij.util.ui.ComboBoxTableCellRenderer;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;

public class AddMultiplyFilesOptionsDialog
extends AbstractAddOptionsDialog {
    private final Collection<AddedFileInfo> myRoots;
    private static final JCheckBox CHECKBOX = new JCheckBox();
    private final ColumnInfo INCLUDED = new ColumnInfo(""){

        public Object valueOf(Object object) {
            return ((AddedFileInfo)object).included();
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public boolean isCellEditable(Object o) {
            return true;
        }

        public void setValue(Object o, Object aValue) {
            ((AddedFileInfo)o).setIncluded((Boolean)aValue);
            AddMultiplyFilesOptionsDialog.this.myTreeTable.repaint();
        }

        public int getWidth(JTable table) {
            return CHECKBOX.getPreferredSize().width + 4;
        }
    };
    private static final ColumnInfo FILE = new ColumnInfo(CvsBundle.message((String)"add.multiple.files.file.column.name", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((AddedFileInfo)object).getPresentableText();
        }

        public Class getColumnClass() {
            return TreeTableModel.class;
        }

        public boolean isCellEditable(Object o) {
            return true;
        }
    };
    private static final ColumnInfo KEYWORD_SUBSTITUTION = new ColumnInfo(CvsBundle.message((String)"add.multiple.files.keyword.substitution.column.name", (Object[])new Object[0])){

        public Object valueOf(Object object) {
            return ((AddedFileInfo)object).getKeywordSubstitutionsWithSelection();
        }

        public boolean isCellEditable(Object o) {
            AddedFileInfo addedFileInfo = (AddedFileInfo)o;
            if (addedFileInfo.getFile().isDirectory()) {
                return false;
            }
            return addedFileInfo.included();
        }

        public void setValue(Object o, Object aValue) {
            ((AddedFileInfo)o).setKeywordSubstitution(((KeywordSubstitutionWrapper)aValue).getSubstitution());
        }

        public TableCellRenderer getRenderer(Object o) {
            AddedFileInfo addedFileInfo = (AddedFileInfo)o;
            if (addedFileInfo.getFile().isDirectory()) {
                return TABLE_CELL_RENDERER;
            }
            return ComboBoxTableCellRenderer.INSTANCE;
        }

        public TableCellEditor getEditor(Object item) {
            return ComboBoxTableCellEditor.INSTANCE;
        }

        public int getWidth(JTable table) {
            return table.getFontMetrics(table.getFont()).stringWidth(this.getName()) + 10;
        }
    };
    private final ColumnInfo[] COLUMNS = new ColumnInfo[]{this.INCLUDED, FILE, KEYWORD_SUBSTITUTION};
    private TreeTable myTreeTable;
    private ListTreeTableModelOnColumns myModel;
    private static final JPanel J_PANEL = new JPanel();
    private static final TableCellRenderer TABLE_CELL_RENDERER = new TableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            J_PANEL.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            return J_PANEL;
        }
    };
    private final Observer myObserver;

    public AddMultiplyFilesOptionsDialog(Project project, Collection<AddedFileInfo> roots, Options options) {
        super(project, options);
        this.myRoots = roots;
        this.myObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AddMultiplyFilesOptionsDialog.this.setOKButtonEnabling();
            }
        };
        Iterator<AddedFileInfo> each = this.myRoots.iterator();
        while (each.hasNext()) {
            each.next().addIncludedObserver(this.myObserver);
        }
        this.setTitle(CvsBundle.message((String)"dialog.title.add.files.to.cvs", (Object[])new Object[0]));
        this.createTree();
        this.expandAll();
        this.init();
        this.setOKButtonEnabling();
    }

    private void setOKButtonEnabling() {
        this.setOKActionEnabled(this.hasIncludedNodes());
    }

    private boolean hasIncludedNodes() {
        for (AddedFileInfo addedFileInfo : this.myRoots) {
            if (!addedFileInfo.hasIncludedNodes()) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
        Iterator<AddedFileInfo> each = this.myRoots.iterator();
        while (each.hasNext()) {
            each.next().removeIncludedObserver(this.myObserver);
        }
    }

    private void expandAll() {
        TreeTableTree tree = this.myTreeTable.getTree();
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
    }

    private void createTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        Iterator<AddedFileInfo> each = this.myRoots.iterator();
        while (each.hasNext()) {
            root.add(each.next());
        }
        this.myModel = new ListTreeTableModelOnColumns((TreeNode)root, this.COLUMNS);
        this.myTreeTable = new TreeTableView(this.myModel);
        int comboHeight = new JComboBox<E>().getPreferredSize().height;
        int checkBoxHeight = new JCheckBox().getPreferredSize().height;
        this.myTreeTable.setMinRowHeight(Math.max(comboHeight, checkBoxHeight) + 2);
        this.myTreeTable.setRootVisible(false);
        this.myTreeTable.getTree().setCellRenderer((TreeCellRenderer)new AddedFileCellRenderer());
        TreeUIHelper.getInstance().installToolTipHandler((JTable)this.myTreeTable);
        TreeUtil.installActions((JTree)this.myTreeTable.getTree());
    }

    protected JComponent createCenterPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JComponent toolbal = this.createToolbal();
        result.add((Component)toolbal, "North");
        result.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myTreeTable), "Center");
        return result;
    }

    private JComponent createToolbal() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new SelectAllAction());
        group.add((AnAction)new UnselectAllAction());
        return actionManager.createActionToolbar("AddFilesToolbar", (ActionGroup)group, true).getComponent();
    }

    private class UnselectAllAction
    extends SelectUnselectAllAction {
        public UnselectAllAction() {
            super(CvsBundle.message((String)"action.name.unselect.all", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/unselectall.png"));
        }

        @Override
        protected boolean includedValue() {
            return false;
        }
    }

    private class SelectAllAction
    extends SelectUnselectAllAction {
        public SelectAllAction() {
            super(CvsBundle.message((String)"action.name.select.all", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/selectall.png"));
        }

        @Override
        protected boolean includedValue() {
            return true;
        }
    }

    private abstract class SelectUnselectAllAction
    extends AnAction {
        protected SelectUnselectAllAction(String text, Icon icon) {
            super(text, null, icon);
        }

        public void actionPerformed(AnActionEvent e) {
            Iterator iterator = this.getAllFileInfos().iterator();
            while (iterator.hasNext()) {
                ((AddedFileInfo)iterator.next()).setIncluded(this.includedValue());
            }
            AddMultiplyFilesOptionsDialog.this.myTreeTable.repaint();
        }

        private Collection getAllFileInfos() {
            ArrayList result = new ArrayList();
            Iterator iterator = AddMultiplyFilesOptionsDialog.this.myRoots.iterator();
            while (iterator.hasNext()) {
                this.addChildrenTo(result, (AddedFileInfo)iterator.next());
            }
            return result;
        }

        private void addChildrenTo(ArrayList result, AddedFileInfo addedFileInfo) {
            result.add(addedFileInfo);
            for (int i = 0; i < addedFileInfo.getChildCount(); ++i) {
                this.addChildrenTo(result, (AddedFileInfo)addedFileInfo.getChildAt(i));
            }
        }

        protected abstract boolean includedValue();
    }
}

