/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.javacvsImpl.io;

import com.intellij.cvsSupport2.cvsoperations.common.ReceivedFileProcessor;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.LineReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.cvsclient.file.IReaderFactory;
import org.netbeans.lib.cvsclient.file.IReceiveTextFilePreprocessor;

public class ReceiveTextFilePreprocessor
implements IReceiveTextFilePreprocessor {
    private final ReceivedFileProcessor myReceivedFileProcessor;
    private final Map<File, String> myFileToSeparator = new HashMap();

    public ReceiveTextFilePreprocessor(ReceivedFileProcessor receivedFileProcessor) {
        this.myReceivedFileProcessor = receivedFileProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTextFileToLocation(File textFileSource, File targetFile, IReaderFactory readerFactory, Charset charSet) throws IOException {
        VirtualFile virtualFile = CvsVfsUtil.findFileByIoFile(targetFile);
        if (this.myReceivedFileProcessor.shouldProcess(virtualFile, targetFile)) {
            PrintStream target = new PrintStream(new BufferedOutputStream(new FileOutputStream(targetFile)));
            try {
                String lineSeparator = this.getLineSeparatorFor(targetFile);
                byte[] lineSeparatorBytes = null;
                if (charSet != null) {
                    lineSeparatorBytes = charSet.encode(lineSeparator).array();
                }
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(textFileSource));
                try {
                    List lines = new LineReader((InputStream)inputStream).readLines();
                    Iterator each = lines.iterator();
                    while (each.hasNext()) {
                        byte[] bytes = (byte[])each.next();
                        if (charSet == null) {
                            target.write(bytes);
                        } else {
                            target.write(charSet.encode(CharsetToolkit.UTF8_CHARSET.decode(ByteBuffer.wrap(bytes))).array());
                        }
                        if (!each.hasNext()) continue;
                        if (charSet == null) {
                            target.print(lineSeparator);
                            continue;
                        }
                        target.write(lineSeparatorBytes);
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            finally {
                target.close();
            }
        }
    }

    private String getLineSeparatorFor(File file) {
        if (this.myFileToSeparator.containsKey(file)) {
            return this.myFileToSeparator.get(file);
        }
        return CodeStyleSettingsManager.getInstance().getCurrentSettings().getLineSeparator();
    }

    public void saveLineSeparatorForFile(VirtualFile virtualFile, String lineSeparatorFor) {
        this.myFileToSeparator.put(CvsVfsUtil.getFileFor(virtualFile), lineSeparatorFor);
    }
}

