/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration;

import com.intellij.execution.LocatableConfigurationType;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiElement;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestData;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class TestNGConfigurationType
implements LocatableConfigurationType {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    private static final Icon ICON = IconLoader.getIcon((String)"/resources/testNG.png");
    private final ConfigurationFactory myFactory = new ConfigurationFactory((ConfigurationType)this){

        public RunConfiguration createTemplateConfiguration(Project project) {
            LOGGER.info("Create TestNG Template Configuration");
            return new TestNGConfiguration("", project, this);
        }

        public Icon getIcon(@NotNull RunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/configuration/TestNGConfigurationType$1.getIcon must not be null");
            }
            return RunConfigurationExtension.getIcon((ModuleBasedConfiguration)((TestNGConfiguration)configuration), (Icon)ICON);
        }
    };

    public static TestNGConfigurationType getInstance() {
        return (TestNGConfigurationType)ConfigurationTypeUtil.findConfigurationType(TestNGConfigurationType.class);
    }

    public RunnerAndConfigurationSettings createConfigurationByLocation(Location location) {
        return null;
    }

    public boolean isConfigurationByLocation(RunConfiguration runConfiguration, Location location) {
        TestNGConfiguration config = (TestNGConfiguration)runConfiguration;
        TestData testobject = config.getPersistantData();
        if (testobject == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (testobject.isConfiguredByElement(element)) {
            Module configurationModule = ((JavaRunConfigurationModule)config.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location.getModule(), (Object)configurationModule)) {
                return true;
            }
            Module predefinedModule = ((JavaRunConfigurationModule)((TestNGConfiguration)((RunManagerImpl)RunManagerEx.getInstanceEx((Project)location.getProject())).getConfigurationTemplate(this.myFactory).getConfiguration()).getConfigurationModule()).getModule();
            return Comparing.equal((Object)predefinedModule, (Object)configurationModule);
        }
        return false;
    }

    public String getDisplayName() {
        return "TestNG";
    }

    public String getConfigurationTypeDescription() {
        return "TestNG Configuration";
    }

    public Icon getIcon() {
        return ICON;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public String getId() {
        if ("TestNG" == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/configuration/TestNGConfigurationType.getId must not return null");
        }
        return "TestNG";
    }
}

