/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.Bootstrap;
import com.intellij.openapi.util.Comparing;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JOptionPane;

public class Main {
    private static boolean isHeadless;

    private Main() {
    }

    public static void main(String[] args) {
        if (Main.installPatch()) {
            JOptionPane.showMessageDialog(null, "The application cannot start right away since some critical files have been changed, please restart it manually.");
            return;
        }
        isHeadless = Main.isHeadless(args);
        if (isHeadless) {
            System.setProperty("java.awt.headless", Boolean.TRUE.toString());
        } else if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("Unable to detect graphics environment");
        }
        Bootstrap.main(args, Main.class.getName() + "Impl", "start");
    }

    public static boolean isHeadless(String[] args) {
        String inspectAppCode = "inspect";
        String antAppCode = "ant";
        String duplocateCode = "duplocate";
        String traverseUI = "traverseUI";
        return args.length > 0 && (Comparing.strEqual((String)args[0], (String)"inspect") || Comparing.strEqual((String)args[0], (String)"ant") || Comparing.strEqual((String)args[0], (String)"duplocate") || Comparing.strEqual((String)args[0], (String)"traverseUI"));
    }

    public static boolean isCommandLine(String[] args) {
        if (Main.isHeadless(args)) {
            return true;
        }
        String diffAppCode = "diff";
        return args.length > 0 && Comparing.strEqual((String)args[0], (String)"diff");
    }

    public static boolean isHeadless() {
        return isHeadless;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private static boolean installPatch() {
        try {
            File ideaHomeDir = Main.getIdeaHomeDir();
            if (ideaHomeDir == null) {
                return false;
            }
            String platform = System.getProperty("idea.platform.prefix", "idea");
            String patchFileName = "jetbrains.patch.jar." + platform;
            File patchFile = new File(System.getProperty("java.io.tmpdir"), patchFileName);
            if (!patchFile.exists()) {
                return false;
            }
            try {
                boolean bl;
                ArrayList<String> args = new ArrayList<String>();
                if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    File launcherFile = new File(ideaHomeDir, "bin/vistalauncher.exe");
                    File launcherCopy = File.createTempFile("vistalauncher", ".exe");
                    launcherCopy.deleteOnExit();
                    Main.copyFile(launcherFile, launcherCopy);
                    args.add(launcherCopy.getPath());
                }
                Collections.addAll(args, System.getProperty("java.home") + "/bin/java", "-classpath", patchFile.getPath(), "com.intellij.updater.Runner", "install", ideaHomeDir.getPath());
                Process process = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
                Thread outThread = new Thread(new StreamRedirector(process.getInputStream(), System.out));
                Thread errThread = new Thread(new StreamRedirector(process.getErrorStream(), System.err));
                outThread.start();
                errThread.start();
                try {
                    boolean requiresRestart;
                    bl = requiresRestart = process.waitFor() == 42;
                }
                catch (Throwable throwable) {
                    outThread.join();
                    errThread.join();
                    throw throwable;
                }
                outThread.join();
                errThread.join();
                return bl;
            }
            finally {
                patchFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static File getIdeaHomeDir() throws IOException {
        URL url = Bootstrap.class.getResource("");
        if (url == null || !"jar".equals(url.getProtocol())) {
            return null;
        }
        String path = url.getPath();
        int start = path.indexOf("file:/");
        int end = path.indexOf("!/");
        if (start == -1 || end == -1) {
            return null;
        }
        String jarFileUrl = path.substring(start, end);
        try {
            File bootstrapJar = new File(new URI(jarFileUrl));
            return bootstrapJar.getParentFile().getParentFile();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        to.getParentFile().mkdirs();
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(from);
            os = new FileOutputStream(to);
            Main.copyStream(is, os);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void copyStream(InputStream from, OutputStream to) throws IOException {
        int read;
        byte[] buffer = new byte[65536];
        while ((read = from.read(buffer)) >= 0) {
            to.write(buffer, 0, read);
        }
    }

    private static class StreamRedirector
    implements Runnable {
        private final InputStream myIn;
        private final OutputStream myOut;

        private StreamRedirector(InputStream in, OutputStream out) {
            this.myIn = in;
            this.myOut = out;
        }

        @Override
        public void run() {
            try {
                Main.copyStream(this.myIn, this.myOut);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

