/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.codeStyle.MultilanguageCodeStyleAbstractPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public abstract class OptionTreeWithPreviewPanel
extends MultilanguageCodeStyleAbstractPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.CodeStyleSpacesPanel");
    private final JTree myOptionsTree;
    private final HashMap myKeyToFieldMap = new HashMap();
    private final ArrayList myKeys = new ArrayList();
    private final JPanel myPanel = new JPanel(new GridBagLayout());

    public OptionTreeWithPreviewPanel(CodeStyleSettings settings) {
        super(settings);
        this.initTables();
        this.myOptionsTree = this.createOptionsTree();
        this.myOptionsTree.setCellRenderer(new MyTreeCellRenderer());
        this.myPanel.add((Component)new JScrollPane(this.myOptionsTree), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(7, 7, 3, 4), 0, 0));
        JPanel previewPanel = OptionTreeWithPreviewPanel.createPreviewPanel();
        this.myPanel.add((Component)previewPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 4), 0, 0));
        this.installPreviewPanel(previewPanel);
        this.addPanelToWatch(this.myPanel);
    }

    protected JTree createOptionsTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        String groupName = "";
        DefaultMutableTreeNode groupNode = null;
        for (int i = 0; i < this.myKeys.size(); ++i) {
            String newGroupName;
            Object key;
            if (this.myKeys.get(i) instanceof BooleanOptionKey) {
                key = (BooleanOptionKey)this.myKeys.get(i);
                newGroupName = ((BooleanOptionKey)key).groupName;
                if (!newGroupName.equals(groupName) || groupNode == null) {
                    groupName = newGroupName;
                    groupNode = new DefaultMutableTreeNode(newGroupName);
                    rootNode.add(groupNode);
                }
                groupNode.add(new MyToggleTreeNode(key, ((BooleanOptionKey)key).cbName));
                continue;
            }
            if (!(this.myKeys.get(i) instanceof IntSelectionOptionKey)) continue;
            key = (IntSelectionOptionKey)this.myKeys.get(i);
            newGroupName = ((IntSelectionOptionKey)key).groupName;
            if (!newGroupName.equals(groupName) || groupNode == null) {
                groupName = newGroupName;
                groupNode = new DefaultMutableTreeNode(newGroupName);
                rootNode.add(groupNode);
            }
            MyToggleTreeNode[] nodes = new MyToggleTreeNode[((IntSelectionOptionKey)key).rbNames.length];
            for (int j = 0; j < nodes.length; ++j) {
                nodes[j] = new MyToggleTreeNode(key, ((IntSelectionOptionKey)key).rbNames[j]);
                groupNode.add(nodes[j]);
            }
            ((IntSelectionOptionKey)key).setCreatedNodes(nodes);
        }
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        final Tree optionsTree = new Tree((TreeModel)model);
        TreeUtil.installActions((JTree)optionsTree);
        optionsTree.setRootVisible(false);
        UIUtil.setLineStyleAngled((JTree)optionsTree);
        optionsTree.setShowsRootHandles(true);
        optionsTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!optionsTree.isEnabled()) {
                    return;
                }
                if (e.getKeyCode() == 32) {
                    TreePath treePath = optionsTree.getLeadSelectionPath();
                    OptionTreeWithPreviewPanel.this.selectCheckbox(treePath);
                    e.consume();
                }
            }
        });
        optionsTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!optionsTree.isEnabled()) {
                    return;
                }
                TreePath treePath = optionsTree.getPathForLocation(e.getX(), e.getY());
                OptionTreeWithPreviewPanel.this.selectCheckbox(treePath);
            }
        });
        for (int row = 0; row < optionsTree.getRowCount(); ++row) {
            optionsTree.expandRow(row);
        }
        return optionsTree;
    }

    private void selectCheckbox(TreePath treePath) {
        if (treePath == null) {
            return;
        }
        Object o = treePath.getLastPathComponent();
        if (o instanceof MyToggleTreeNode) {
            MyToggleTreeNode node = (MyToggleTreeNode)o;
            if (node.isCheckbox()) {
                node.setSelected(!node.isSelected());
            } else {
                MyToggleTreeNode[] group = node.getGroup();
                for (int i = 0; i < group.length; ++i) {
                    MyToggleTreeNode groupNode = group[i];
                    groupNode.setSelected(false);
                    int row = this.myOptionsTree.getRowForPath(new TreePath(groupNode.getPath()));
                    this.myOptionsTree.repaint(this.myOptionsTree.getRowBounds(row));
                }
                node.setSelected(true);
            }
            int row = this.myOptionsTree.getRowForPath(treePath);
            this.myOptionsTree.repaint(this.myOptionsTree.getRowBounds(row));
            this.somethingChanged();
        }
    }

    protected abstract void initTables();

    @Override
    protected int getRightMargin() {
        return -1;
    }

    @Override
    protected void resetImpl(CodeStyleSettings settings) {
        TreeModel treeModel = this.myOptionsTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        this.resetNode(root, settings);
    }

    private void resetNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyToggleTreeNode) {
            this.resetMyTreeNode((MyToggleTreeNode)node, settings);
            return;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            this.resetNode(child, settings);
        }
    }

    private void resetMyTreeNode(MyToggleTreeNode childNode, CodeStyleSettings settings) {
        try {
            if (childNode.getKey() instanceof BooleanOptionKey) {
                BooleanOptionKey key = (BooleanOptionKey)childNode.getKey();
                Field field = (Field)this.myKeyToFieldMap.get((Object)key);
                childNode.setSelected(field.getBoolean(settings));
            } else if (childNode.getKey() instanceof IntSelectionOptionKey) {
                IntSelectionOptionKey key = (IntSelectionOptionKey)childNode.getKey();
                Field field = (Field)this.myKeyToFieldMap.get((Object)key);
                int fieldValue = field.getInt(settings);
                for (int i = 0; i < key.rbNames.length; ++i) {
                    if (!childNode.getText().equals(key.rbNames[i])) continue;
                    childNode.setSelected(fieldValue == key.values[i]);
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        TreeModel treeModel = this.myOptionsTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        this.applyNode(root, settings);
    }

    private void applyNode(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyToggleTreeNode) {
            this.applyToggleNode((MyToggleTreeNode)node, settings);
            return;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            this.applyNode(child, settings);
        }
    }

    private void applyToggleNode(MyToggleTreeNode childNode, CodeStyleSettings settings) {
        block6: {
            try {
                if (childNode.getKey() instanceof BooleanOptionKey) {
                    BooleanOptionKey key = (BooleanOptionKey)childNode.getKey();
                    Field field = (Field)this.myKeyToFieldMap.get((Object)key);
                    field.set(settings, childNode.isSelected() ? Boolean.TRUE : Boolean.FALSE);
                    break block6;
                }
                if (!(childNode.getKey() instanceof IntSelectionOptionKey)) break block6;
                if (!childNode.isSelected()) {
                    return;
                }
                IntSelectionOptionKey key = (IntSelectionOptionKey)childNode.getKey();
                Field field = (Field)this.myKeyToFieldMap.get((Object)key);
                for (int i = 0; i < key.rbNames.length; ++i) {
                    if (!childNode.getText().equals(key.rbNames[i])) continue;
                    field.set(settings, new Integer(key.values[i]));
                    break;
                }
            }
            catch (IllegalArgumentException e) {
                LOG.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        TreeModel treeModel = this.myOptionsTree.getModel();
        TreeNode root = (TreeNode)treeModel.getRoot();
        return this.isModified(root, settings);
    }

    private boolean isModified(TreeNode node, CodeStyleSettings settings) {
        if (node instanceof MyToggleTreeNode && this.isToggleNodeModified((MyToggleTreeNode)node, settings)) {
            return true;
        }
        for (int j = 0; j < node.getChildCount(); ++j) {
            TreeNode child = node.getChildAt(j);
            if (!this.isModified(child, settings)) continue;
            return true;
        }
        return false;
    }

    private boolean isToggleNodeModified(MyToggleTreeNode childNode, CodeStyleSettings settings) {
        try {
            if (childNode.getKey() instanceof BooleanOptionKey) {
                BooleanOptionKey key = (BooleanOptionKey)childNode.getKey();
                Field field = (Field)this.myKeyToFieldMap.get((Object)key);
                return childNode.isSelected() != field.getBoolean(settings);
            }
            if (childNode.getKey() instanceof IntSelectionOptionKey) {
                if (!childNode.isSelected()) {
                    return false;
                }
                IntSelectionOptionKey key = (IntSelectionOptionKey)childNode.getKey();
                Field field = (Field)this.myKeyToFieldMap.get((Object)key);
                for (int i = 0; i < key.rbNames.length; ++i) {
                    if (!childNode.getText().equals(key.rbNames[i])) continue;
                    return field.getInt(settings) != key.values[i];
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    protected void initBooleanField(@NonNls String fieldName, String cbName, String groupName) {
        try {
            Class<CodeStyleSettings> styleSettingsClass = CodeStyleSettings.class;
            Field field = styleSettingsClass.getField(fieldName);
            BooleanOptionKey key = new BooleanOptionKey(groupName, cbName);
            this.myKeyToFieldMap.put((Object)key, (Object)field);
            this.myKeys.add(key);
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    protected void initRadioGroupField(String fieldName, String groupName, String[] rbNames, int[] values) {
        try {
            Class<CodeStyleSettings> styleSettingsClass = CodeStyleSettings.class;
            Field field = styleSettingsClass.getField(fieldName);
            IntSelectionOptionKey key = new IntSelectionOptionKey(groupName, rbNames, values);
            this.myKeyToFieldMap.put((Object)key, (Object)field);
            this.myKeys.add(key);
        }
        catch (NoSuchFieldException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
    }

    @Override
    protected void prepareForReformat(PsiFile psiFile) {
    }

    public JComponent getInternalPanel() {
        return this.myPanel;
    }

    private static class MyToggleTreeNode
    extends DefaultMutableTreeNode {
        private final Object myKey;
        private final String myText;
        private boolean isSelected;
        private final boolean isCheckbox;

        public MyToggleTreeNode(Object key, String text) {
            this.myKey = key;
            this.myText = text;
            this.isCheckbox = true;
        }

        public Object getKey() {
            return this.myKey;
        }

        public String getText() {
            return this.myText;
        }

        public boolean isCheckbox() {
            return this.isCheckbox;
        }

        public void setSelected(boolean val) {
            this.isSelected = val;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public MyToggleTreeNode[] getGroup() {
            return ((IntSelectionOptionKey)this.myKey).getNodes();
        }
    }

    private static class IntSelectionOptionKey {
        final String groupName;
        final String[] rbNames;
        final int[] values;
        private MyToggleTreeNode[] myNodes;

        public IntSelectionOptionKey(String groupName, String[] rbNames, int[] values) {
            this.groupName = groupName;
            this.rbNames = rbNames;
            this.values = values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntSelectionOptionKey)) {
                return false;
            }
            IntSelectionOptionKey intSelectionOptionKey = (IntSelectionOptionKey)o;
            if (!this.groupName.equals(intSelectionOptionKey.groupName)) {
                return false;
            }
            return Arrays.equals(this.rbNames, intSelectionOptionKey.rbNames);
        }

        public int hashCode() {
            return this.groupName.hashCode() + this.rbNames[0].hashCode() * 29;
        }

        public void setCreatedNodes(MyToggleTreeNode[] nodes) {
            this.myNodes = nodes;
        }

        public MyToggleTreeNode[] getNodes() {
            return this.myNodes;
        }
    }

    private static class BooleanOptionKey {
        final String groupName;
        final String cbName;

        public BooleanOptionKey(String groupName, String cbName) {
            this.groupName = groupName;
            this.cbName = cbName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BooleanOptionKey)) {
                return false;
            }
            BooleanOptionKey key = (BooleanOptionKey)obj;
            return this.groupName.equals(key.groupName) && this.cbName.equals(key.cbName);
        }

        public int hashCode() {
            return this.cbName.hashCode();
        }
    }

    private static class MyLabelPanel
    extends JPanel {
        private String myText = "";
        private final boolean hasFocus = false;

        public void setText(String text) {
            this.myText = text;
            if (this.myText == null) {
                this.myText = "";
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setFont(this.getMyFont());
            FontMetrics fontMetrics = this.getFontMetrics(this.getMyFont());
            int h = fontMetrics.getHeight();
            int w = fontMetrics.charsWidth(this.myText.toCharArray(), 0, this.myText.length());
            g.setColor(this.getBackground());
            g.fillRect(0, 1, w + 2, h);
            g.setColor(this.getForeground());
            g.drawString(this.myText, 2, h - fontMetrics.getDescent() + 1);
        }

        private Font getMyFont() {
            Font font = UIUtil.getTreeFont();
            return new Font(font.getName(), 1, font.getSize());
        }

        @Override
        public Dimension getPreferredSize() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getMyFont());
            if (fontMetrics == null) {
                return new Dimension(0, 0);
            }
            int h = fontMetrics.getHeight();
            int w = fontMetrics.charsWidth(this.myText.toCharArray(), 0, this.myText.length());
            return new Dimension(w + 4, h + 2);
        }
    }

    protected class MyTreeCellRenderer
    implements TreeCellRenderer {
        private final MyLabelPanel myLabel = new MyLabelPanel();
        private final JCheckBox myCheckBox = new JCheckBox();
        private final JRadioButton myRadioButton = new JRadioButton();

        public MyTreeCellRenderer() {
            this.myCheckBox.setMargin(new Insets(0, 0, 0, 0));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof MyToggleTreeNode) {
                MyToggleTreeNode treeNode = (MyToggleTreeNode)value;
                JToggleButton button = treeNode.isCheckbox() ? this.myCheckBox : this.myRadioButton;
                button.setText(treeNode.getText());
                button.setSelected(treeNode.isSelected);
                if (isSelected) {
                    button.setForeground(UIUtil.getTreeSelectionForeground());
                    button.setBackground(UIUtil.getTreeSelectionBackground());
                } else {
                    button.setForeground(UIUtil.getTreeTextForeground());
                    button.setBackground(UIUtil.getTreeTextBackground());
                }
                button.setEnabled(tree.isEnabled());
                return button;
            }
            Font font = tree.getFont();
            Font boldFont = new Font(font.getName(), 1, font.getSize());
            this.myLabel.setFont(boldFont);
            this.myLabel.setText(value.toString());
            if (isSelected) {
                this.myLabel.setForeground(UIUtil.getTreeSelectionForeground());
                this.myLabel.setBackground(UIUtil.getTreeSelectionBackground());
            } else {
                this.myLabel.setForeground(UIUtil.getTreeTextForeground());
                this.myLabel.setBackground(UIUtil.getTreeTextBackground());
            }
            this.myLabel.setEnabled(tree.isEnabled());
            return this.myLabel;
        }
    }
}

