/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ReflectionCache;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;

public class CodeInsightUtilBase {
    private CodeInsightUtilBase() {
    }

    static <T extends PsiElement> T findElementInRange(PsiFile file, int startOffset, int endOffset, Class<T> klass, Language language) {
        PsiElement element;
        PsiElement element1 = file.getViewProvider().findElementAt(startOffset, language);
        PsiElement element2 = file.getViewProvider().findElementAt(endOffset - 1, language);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.getViewProvider().findElementAt(startOffset, language);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.getViewProvider().findElementAt(endOffset - 1, language);
        }
        if (element2 == null || element1 == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        PsiElement psiElement = element = ReflectionCache.isAssignable(klass, commonParent.getClass()) ? commonParent : PsiTreeUtil.getParentOfType((PsiElement)commonParent, klass);
        if (element == null || element.getTextRange().getStartOffset() != startOffset || element.getTextRange().getEndOffset() != endOffset) {
            return null;
        }
        return (T)element;
    }

    public static <T extends PsiElement> T forcePsiPostprocessAndRestoreElement(T element) {
        PsiFile psiFile = element.getContainingFile();
        Document document = psiFile.getViewProvider().getDocument();
        if (document == null) {
            return element;
        }
        Language language = PsiUtilBase.getDialect(element);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)psiFile.getProject());
        RangeMarker rangeMarker = document.createRangeMarker(element.getTextRange());
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        documentManager.commitDocument(document);
        return (T)CodeInsightUtilBase.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), element.getClass(), language);
    }

    public static boolean prepareFileForWrite(PsiFile psiFile) {
        Editor editor;
        if (psiFile == null) {
            return false;
        }
        final VirtualFile file = psiFile.getVirtualFile();
        Project project = psiFile.getProject();
        Editor editor2 = editor = psiFile.isWritable() ? null : FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file), true);
        if (!ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file})) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (editor != null && editor.getComponent().isDisplayable()) {
                        HintManager.getInstance().showErrorHint(editor, CodeInsightBundle.message((String)"error.hint.file.is.readonly", (Object[])new Object[]{file.getPresentableUrl()}));
                    }
                }
            });
            return false;
        }
        return true;
    }

    public static boolean preparePsiElementForWrite(PsiElement element) {
        PsiFile file = element == null ? null : element.getContainingFile();
        return CodeInsightUtilBase.prepareFileForWrite(file);
    }

    public static boolean preparePsiElementsForWrite(PsiElement ... elements) {
        return CodeInsightUtilBase.preparePsiElementsForWrite(Arrays.asList(elements));
    }

    public static boolean preparePsiElementsForWrite(Collection<? extends PsiElement> elements) {
        if (elements.isEmpty()) {
            return true;
        }
        THashSet files = new THashSet();
        Project project = null;
        for (PsiElement psiElement : elements) {
            VirtualFile virtualFile;
            project = psiElement.getProject();
            PsiFile file = psiElement.getContainingFile();
            if (file == null || (virtualFile = file.getVirtualFile()) == null) continue;
            files.add(virtualFile);
        }
        if (!files.isEmpty()) {
            VirtualFile[] virtualFiles = VfsUtil.toVirtualFileArray((Collection)files);
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(virtualFiles);
            return !operationStatus.hasReadonlyFiles();
        }
        return true;
    }
}

