/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CastingLookupElementDecorator;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaChainLookupElement
extends LookupElementDecorator<LookupElement>
implements TypedLookupItem {
    private final LookupElement myQualifier;

    private JavaChainLookupElement(LookupElement qualifier, LookupElement main) {
        super(main);
        this.myQualifier = qualifier;
    }

    @NotNull
    public String getLookupString() {
        String string = this.maybeAddParentheses(this.myQualifier.getLookupString()) + "." + this.getDelegate().getLookupString();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaChainLookupElement.getLookupString must not return null");
        }
        return string;
    }

    public LookupElement getQualifier() {
        return this.myQualifier;
    }

    public Set<String> getAllLookupStrings() {
        Set strings = this.getDelegate().getAllLookupStrings();
        THashSet result = new THashSet();
        result.addAll((Collection)strings);
        result.add((Object)this.getLookupString());
        return result;
    }

    @NotNull
    public String toString() {
        String string = this.maybeAddParentheses(this.myQualifier.toString()) + "." + this.getDelegate();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaChainLookupElement.toString must not return null");
        }
        return string;
    }

    private String maybeAddParentheses(String s) {
        return this.myQualifier.getObject() instanceof PsiMethod ? s + "()" : s;
    }

    public void renderElement(LookupElementPresentation presentation) {
        super.renderElement(presentation);
        LookupElementPresentation qualifierPresentation = new LookupElementPresentation();
        this.myQualifier.renderElement(qualifierPresentation);
        String name = this.maybeAddParentheses(qualifierPresentation.getItemText());
        String qualifierText = this.myQualifier.as(CastingLookupElementDecorator.class) != null ? "(" + name + ")" : name;
        presentation.setItemText(qualifierText + "." + presentation.getItemText());
    }

    public void handleInsert(InsertionContext context) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.chain");
        Document document = context.getEditor().getDocument();
        document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)";");
        InsertionContext qualifierContext = CompletionUtil.emulateInsertion(context, context.getStartOffset(), this.myQualifier);
        if (JavaChainLookupElement.shouldParenthesizeQualifier(qualifierContext.getFile(), context.getStartOffset(), qualifierContext.getTailOffset())) {
            String space = CodeStyleSettingsManager.getSettings((Project)qualifierContext.getProject()).SPACE_WITHIN_PARENTHESES ? " " : "";
            document.insertString(context.getStartOffset(), (CharSequence)("(" + space));
            document.insertString(qualifierContext.getTailOffset(), (CharSequence)(space + ")"));
        }
        char atTail = document.getCharsSequence().charAt(context.getTailOffset() - 1);
        assert (atTail == ';') : atTail;
        document.replaceString(context.getTailOffset() - 1, context.getTailOffset(), (CharSequence)".");
        CompletionUtil.emulateInsertion(this.getDelegate(), context.getTailOffset(), context);
    }

    private static boolean shouldParenthesizeQualifier(PsiFile file, int startOffset, int endOffset) {
        PsiElement element = file.findElementAt(startOffset);
        if (element == null) {
            return false;
        }
        PsiElement last = element;
        while (element != null && element.getTextRange().getStartOffset() >= startOffset && element.getTextRange().getEndOffset() <= endOffset) {
            last = element;
            element = element.getParent();
        }
        PsiExpression expr = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)last, PsiExpression.class, (boolean)false);
        if (expr == null || expr.getTextRange().getEndOffset() > endOffset) {
            return true;
        }
        return !(expr instanceof PsiReferenceExpression) && !(expr instanceof PsiMethodCallExpression);
    }

    @NotNull
    private LookupElement getComparableQualifier() {
        CastingLookupElementDecorator casting = CastingLookupElementDecorator.from(this.myQualifier);
        LookupElement lookupElement = casting == null ? this.myQualifier : casting.getDelegate();
        if (lookupElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/JavaChainLookupElement.getComparableQualifier must not return null");
        }
        return lookupElement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getComparableQualifier().equals(((JavaChainLookupElement)o).getComparableQualifier());
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.getComparableQualifier().hashCode();
    }

    @Override
    public PsiType getType() {
        Object object = this.getObject();
        if (object instanceof PsiMember) {
            return JavaCompletionUtil.getQualifiedMemberReferenceType(JavaCompletionUtil.getLookupElementType(this.myQualifier), (PsiMember)object);
        }
        return ((PsiVariable)object).getType();
    }

    public static LookupElement chainElements(LookupElement qualifier, LookupElement main) {
        return new JavaChainLookupElement(qualifier, main);
    }
}

