/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipRendererProvider;
import com.intellij.codeInsight.daemon.impl.EditorTracker;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.PassExecutorService;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.daemon.impl.StatusBarUpdater;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonCodeAnalyzerImpl
extends DaemonCodeAnalyzer
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl");
    private static final Key<List<HighlightInfo>> HIGHLIGHTS_IN_EDITOR_DOCUMENT_KEY = Key.create((String)"HIGHLIGHTS_IN_EDITOR_DOCUMENT");
    private static final Key<List<LineMarkerInfo>> MARKERS_IN_EDITOR_DOCUMENT_KEY = Key.create((String)"MARKERS_IN_EDITOR_DOCUMENT");
    private final Project myProject;
    private final DaemonCodeAnalyzerSettings mySettings;
    private final EditorTracker myEditorTracker;
    private DaemonProgressIndicator myUpdateProgress = new DaemonProgressIndicator();
    private DaemonProgressIndicator myUpdateVisibleProgress = new DaemonProgressIndicator();
    private final Runnable myUpdateRunnable = this.createUpdateRunnable();
    private final Alarm myAlarm = new Alarm();
    private boolean myUpdateByTimerEnabled = true;
    private final Collection<VirtualFile> myDisabledHintsFiles = new THashSet();
    private final Collection<PsiFile> myDisabledHighlightingFiles = new THashSet();
    private final FileStatusMap myFileStatusMap;
    private DaemonCodeAnalyzerSettings myLastSettings;
    private IntentionHintComponent myLastIntentionHint;
    private boolean myDisposed;
    private boolean myInitialized;
    @NonNls
    private static final String DISABLE_HINTS_TAG = "disable_hints";
    @NonNls
    private static final String FILE_TAG = "file";
    @NonNls
    private static final String URL_ATT = "url";
    private DaemonListeners myDaemonListeners;
    private StatusBarUpdater myStatusBarUpdater;
    private final PassExecutorService myPassExecutorService;
    private static final Key<List<HighlightInfo>> HIGHLIGHTS_TO_REMOVE_KEY = Key.create((String)"HIGHLIGHTS_TO_REMOVE");
    private int myModificationCount = 0;
    private final List<Pair<NamedScope, NamedScopesHolder>> myScopes = ContainerUtil.createEmptyCOWList();

    public DaemonCodeAnalyzerImpl(Project project, DaemonCodeAnalyzerSettings daemonCodeAnalyzerSettings, EditorTracker editorTracker) {
        this.myProject = project;
        this.mySettings = daemonCodeAnalyzerSettings;
        this.myEditorTracker = editorTracker;
        this.myLastSettings = (DaemonCodeAnalyzerSettings)this.mySettings.clone();
        this.myFileStatusMap = new FileStatusMap(this.myProject);
        this.myPassExecutorService = new PassExecutorService(this.myProject){

            @Override
            protected void afterApplyInformationToEditor(TextEditorHighlightingPass pass, FileEditor fileEditor, ProgressIndicator updateProgress) {
                if (fileEditor instanceof TextEditor) {
                    1.log(updateProgress, pass, "Apply ");
                    Editor editor = ((TextEditor)fileEditor).getEditor();
                    DaemonCodeAnalyzerImpl.this.repaintErrorStripeRenderer(editor);
                }
            }

            @Override
            protected boolean isDisposed() {
                return DaemonCodeAnalyzerImpl.this.myDisposed || super.isDisposed();
            }
        };
        Disposer.register((Disposable)project, (Disposable)this.myPassExecutorService);
        Disposer.register((Disposable)project, (Disposable)this.myFileStatusMap);
    }

    @NotNull
    public String getComponentName() {
        if ("DaemonCodeAnalyzer" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.getComponentName must not return null");
        }
        return "DaemonCodeAnalyzer";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
        assert (!this.myInitialized) : "Double Initializing";
        this.myStatusBarUpdater = new StatusBarUpdater(this.myProject);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myStatusBarUpdater);
        this.myDaemonListeners = new DaemonListeners(this.myProject, this, this.myEditorTracker);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myDaemonListeners);
        this.reloadScopes();
        this.myInitialized = true;
        this.myDisposed = false;
        this.myFileStatusMap.markAllFilesDirty();
    }

    public void projectClosed() {
        assert (this.myInitialized) : "Disposing not initialized component";
        assert (!this.myDisposed) : "Double dispose";
        this.myFileStatusMap.markAllFilesDirty();
        this.stopProcess(false);
        this.myDisposed = true;
        this.myLastSettings = null;
        this.myInitialized = false;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    void repaintErrorStripeRenderer(Editor editor) {
        if (this.myProject.isDisposed()) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
        EditorMarkupModel markup = (EditorMarkupModel)editor.getMarkupModel();
        markup.setErrorStripeRenderer(new TrafficLightRenderer(this.myProject, this, document, psiFile));
        markup.setErrorPanelPopupHandler(new DaemonEditorPopup(psiFile));
        markup.setErrorStripTooltipRendererProvider(new DaemonTooltipRendererProvider(this.myProject));
        markup.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().ERROR_STRIPE_MARK_MIN_HEIGHT);
    }

    void reloadScopes() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<Pair<NamedScope, NamedScopesHolder>> scopeList = new ArrayList<Pair<NamedScope, NamedScopesHolder>>();
        DaemonCodeAnalyzerImpl.addScopesToList(scopeList, (NamedScopesHolder)NamedScopeManager.getInstance((Project)this.myProject));
        DaemonCodeAnalyzerImpl.addScopesToList(scopeList, (NamedScopesHolder)DependencyValidationManager.getInstance((Project)this.myProject));
        this.myScopes.clear();
        this.myScopes.addAll(scopeList);
    }

    private static void addScopesToList(List<Pair<NamedScope, NamedScopesHolder>> scopeList, NamedScopesHolder holder) {
        NamedScope[] scopes;
        for (NamedScope scope : scopes = holder.getScopes()) {
            scopeList.add((Pair<NamedScope, NamedScopesHolder>)Pair.create((Object)scope, (Object)holder));
        }
    }

    @NotNull
    public List<Pair<NamedScope, NamedScopesHolder>> getScopeBasedHighlightingCachedScopes() {
        List<Pair<NamedScope, NamedScopesHolder>> list = this.myScopes;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.getScopeBasedHighlightingCachedScopes must not return null");
        }
        return list;
    }

    public void settingsChanged() {
        DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
        if (settings.isCodeHighlightingChanged(this.myLastSettings)) {
            this.restart();
        }
        this.myLastSettings = (DaemonCodeAnalyzerSettings)settings.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVisibleHighlighters(@NotNull Editor editor) {
        DaemonProgressIndicator progress;
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.updateVisibleHighlighters must not be null");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        BackgroundEditorHighlighter highlighter = textEditor.getBackgroundHighlighter();
        if (highlighter == null) {
            return;
        }
        HighlightingPass[] highlightingPasses = highlighter.createPassesForVisibleArea();
        DaemonCodeAnalyzerImpl daemonCodeAnalyzerImpl = this;
        synchronized (daemonCodeAnalyzerImpl) {
            this.recreateVisibleProgress();
            progress = this.myUpdateVisibleProgress;
        }
        this.myPassExecutorService.renewVisiblePasses(textEditor, highlightingPasses, progress);
    }

    private synchronized void cancelVisibleProgress() {
        if (this.myUpdateVisibleProgress != null) {
            this.myUpdateVisibleProgress.cancel();
            this.myUpdateVisibleProgress = null;
        }
    }

    private synchronized void recreateVisibleProgress() {
        if (this.myUpdateVisibleProgress == null) {
            this.myUpdateVisibleProgress = new DaemonProgressIndicator();
            this.myUpdateVisibleProgress.start();
        }
    }

    public void setUpdateByTimerEnabled(boolean value) {
        this.myUpdateByTimerEnabled = value;
        this.stopProcess(true);
    }

    public void setImportHintsEnabled(PsiFile file, boolean value) {
        VirtualFile vFile = file.getVirtualFile();
        if (value) {
            this.myDisabledHintsFiles.remove(vFile);
            this.stopProcess(true);
        } else {
            this.myDisabledHintsFiles.add(vFile);
            HintManager.getInstance().hideAllHints();
        }
    }

    public void resetImportHintsEnabledForProject() {
        this.myDisabledHintsFiles.clear();
    }

    public void setHighlightingEnabled(PsiFile file, boolean value) {
        if (value) {
            this.myDisabledHighlightingFiles.remove(file);
        } else {
            this.myDisabledHighlightingFiles.add(file);
        }
    }

    public boolean isHighlightingAvailable(PsiFile file) {
        if (this.myDisabledHighlightingFiles.contains(file)) {
            return false;
        }
        if (file == null || !file.isPhysical()) {
            return false;
        }
        if (file instanceof PsiCompiledElement) {
            return false;
        }
        FileType fileType = file.getFileType();
        if (fileType == StdFileTypes.GUI_DESIGNER_FORM) {
            return true;
        }
        return !fileType.isBinary();
    }

    public boolean isImportHintsEnabled(PsiFile file) {
        return this.isAutohintsAvailable(file) && !this.myDisabledHintsFiles.contains(file.getVirtualFile());
    }

    public boolean isAutohintsAvailable(PsiFile file) {
        return this.isHighlightingAvailable(file) && !(file instanceof PsiCompiledElement);
    }

    public void restart() {
        this.myFileStatusMap.markAllFilesDirty();
        this.stopProcess(true);
    }

    public List<TextEditorHighlightingPass> getPassesToShowProgressFor(PsiFile file) {
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        List<TextEditorHighlightingPass> allPasses = this.myPassExecutorService.getAllSubmittedPasses();
        ArrayList<TextEditorHighlightingPass> result = new ArrayList<TextEditorHighlightingPass>(allPasses.size());
        for (TextEditorHighlightingPass pass : allPasses) {
            if (pass.getDocument() != document && pass.getDocument() != null) continue;
            result.add(pass);
        }
        return result;
    }

    public boolean isAllAnalysisFinished(PsiFile file) {
        if (this.myDisposed) {
            return false;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file);
        return document != null && document.getModificationStamp() == file.getModificationStamp() && this.myFileStatusMap.allDirtyScopesAreNull(document);
    }

    public boolean isErrorAnalyzingFinished(PsiFile file) {
        if (this.myDisposed) {
            return false;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file);
        return document != null && document.getModificationStamp() == file.getModificationStamp() && this.myFileStatusMap.getFileDirtyScope(document, 4) == null;
    }

    public FileStatusMap getFileStatusMap() {
        return this.myFileStatusMap;
    }

    public synchronized int getModificationCount() {
        return this.myModificationCount;
    }

    public synchronized boolean isRunning() {
        return this.myUpdateProgress != null && !this.myUpdateProgress.isCanceled();
    }

    public synchronized void stopProcess(boolean toRestartAlarm) {
        boolean restart;
        this.cancelUpdateProgress(toRestartAlarm, "by Stop process");
        this.myAlarm.cancelAllRequests();
        boolean bl = restart = toRestartAlarm && !this.myDisposed && this.myInitialized;
        if (restart) {
            this.myAlarm.addRequest(this.myUpdateRunnable, this.mySettings.AUTOREPARSE_DELAY);
        }
    }

    private synchronized void cancelUpdateProgress(boolean start, @NonNls String reason) {
        PassExecutorService.log(this.myUpdateProgress, null, reason, start);
        ++this.myModificationCount;
        if (this.myUpdateProgress != null) {
            this.myUpdateProgress.cancel();
            this.myPassExecutorService.cancelAll(false);
            this.cancelVisibleProgress();
            this.myUpdateProgress = null;
        }
    }

    private static DaemonProgressIndicator recreateProgress() {
        DaemonProgressIndicator myUpdateProgress = new DaemonProgressIndicator();
        myUpdateProgress.start();
        return myUpdateProgress;
    }

    @Nullable
    public static List<HighlightInfo> getHighlights(Document document, Project project) {
        LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        MarkupModel markup = document.getMarkupModel(project);
        return DaemonCodeAnalyzerImpl.getHighlights(markup);
    }

    static List<HighlightInfo> getHighlights(MarkupModel markup) {
        return (List)markup.getUserData(HIGHLIGHTS_IN_EDITOR_DOCUMENT_KEY);
    }

    @NotNull
    public static List<HighlightInfo> getHighlights(Document document, HighlightSeverity minSeverity, Project project) {
        List<HighlightInfo> list = DaemonCodeAnalyzerImpl.getHighlights(document, minSeverity, project, Integer.MIN_VALUE, Integer.MAX_VALUE);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.getHighlights must not return null");
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<HighlightInfo> getHighlights(Document document, HighlightSeverity minSeverity, Project project, int startOffset, int endOffset) {
        List<HighlightInfo> list;
        LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        List<HighlightInfo> highlights = DaemonCodeAnalyzerImpl.getHighlights(document, project);
        if (highlights == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.getHighlights must not return null");
            return list;
        }
        ArrayList<HighlightInfo> array = new ArrayList<HighlightInfo>();
        SeverityRegistrar instance = SeverityRegistrar.getInstance(project);
        for (HighlightInfo info : highlights) {
            if (instance.compare(info.getSeverity(), minSeverity) < 0 || info.startOffset < startOffset || info.endOffset > endOffset) continue;
            array.add(info);
        }
        list = array;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.getHighlights must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static List<HighlightInfo> getHighlightsAround(Document document, Project project, int offset) {
        List<HighlightInfo> list;
        LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        List<HighlightInfo> highlights = DaemonCodeAnalyzerImpl.getHighlights(document, project);
        if (highlights == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.getHighlightsAround must not return null");
            return list;
        }
        ArrayList<HighlightInfo> array = new ArrayList<HighlightInfo>();
        for (HighlightInfo info : highlights) {
            if (!DaemonCodeAnalyzerImpl.isOffsetInsideHighlightInfo(offset, info, true)) continue;
            array.add(info);
        }
        list = array;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.getHighlightsAround must not return null");
    }

    @Nullable
    public HighlightInfo findHighlightByOffset(Document document, int offset, boolean includeFixRange) {
        List<HighlightInfo> highlights = DaemonCodeAnalyzerImpl.getHighlights(document, this.myProject);
        if (highlights == null) {
            return null;
        }
        SmartList foundInfoList = new SmartList();
        for (HighlightInfo info : highlights) {
            if (!DaemonCodeAnalyzerImpl.isOffsetInsideHighlightInfo(offset, info, includeFixRange)) continue;
            if (!foundInfoList.isEmpty()) {
                HighlightInfo foundInfo = (HighlightInfo)foundInfoList.get(0);
                int compare = foundInfo.getSeverity().compareTo(info.getSeverity());
                if (compare < 0) {
                    foundInfoList.clear();
                } else if (compare > 0) continue;
            }
            foundInfoList.add(info);
        }
        if (foundInfoList.isEmpty()) {
            return null;
        }
        if (foundInfoList.size() == 1) {
            return (HighlightInfo)foundInfoList.get(0);
        }
        return new HighlightInfoComposite((List<HighlightInfo>)foundInfoList);
    }

    private static boolean isOffsetInsideHighlightInfo(int offset, HighlightInfo info, boolean includeFixRange) {
        if (info.highlighter == null || !info.highlighter.isValid()) {
            return false;
        }
        int startOffset = info.highlighter.getStartOffset();
        int endOffset = info.highlighter.getEndOffset();
        if (startOffset > offset || offset > endOffset) {
            if (!includeFixRange) {
                return false;
            }
            if (info.fixMarker == null || !info.fixMarker.isValid()) {
                return false;
            }
            startOffset = info.fixMarker.getStartOffset();
            endOffset = info.fixMarker.getEndOffset();
            if (startOffset > offset || offset > endOffset) {
                return false;
            }
        }
        return true;
    }

    static void setHighlights(MarkupModel markup, Project project, List<HighlightInfo> highlightsToSet, List<HighlightInfo> highlightsToRemove) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DaemonCodeAnalyzerImpl.stripWarningsCoveredByErrors(project, highlightsToSet, markup);
        markup.putUserData(HIGHLIGHTS_IN_EDITOR_DOCUMENT_KEY, Collections.unmodifiableList(highlightsToSet));
        markup.putUserData(HIGHLIGHTS_TO_REMOVE_KEY, Collections.unmodifiableList(highlightsToRemove));
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        if (codeAnalyzer instanceof DaemonCodeAnalyzerImpl && ((DaemonCodeAnalyzerImpl)codeAnalyzer).myStatusBarUpdater != null) {
            ((DaemonCodeAnalyzerImpl)codeAnalyzer).myStatusBarUpdater.updateStatus();
        }
    }

    private static void stripWarningsCoveredByErrors(Project project, List<HighlightInfo> highlights, MarkupModel markup) {
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getInstance(project);
        ArrayList<HighlightInfo> errors = new ArrayList<HighlightInfo>();
        for (HighlightInfo highlight : highlights) {
            if (severityRegistrar.compare(highlight.getSeverity(), HighlightSeverity.ERROR) < 0) continue;
            errors.add(highlight);
        }
        Iterator<HighlightInfo> it = highlights.iterator();
        block1: while (it.hasNext()) {
            HighlightInfo highlight;
            highlight = it.next();
            if (severityRegistrar.compare(HighlightSeverity.ERROR, highlight.getSeverity()) <= 0 || highlight.getSeverity().myVal <= 0) continue;
            for (HighlightInfo errorInfo : errors) {
                if (!DaemonCodeAnalyzerImpl.isCoveredBy(highlight, errorInfo)) continue;
                it.remove();
                RangeHighlighterEx highlighter = highlight.highlighter;
                if (highlighter == null) continue block1;
                markup.removeHighlighter((RangeHighlighter)highlighter);
                continue block1;
            }
        }
    }

    private static boolean isCoveredBy(HighlightInfo info, HighlightInfo coveredBy) {
        return info.startOffset >= coveredBy.startOffset && info.endOffset <= coveredBy.endOffset && info.getGutterIconRenderer() == null;
    }

    @Nullable
    public static List<LineMarkerInfo> getLineMarkers(Document document, Project project) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModel markup = document.getMarkupModel(project);
        return (List)markup.getUserData(MARKERS_IN_EDITOR_DOCUMENT_KEY);
    }

    public static void setLineMarkers(@NotNull Document document, List<LineMarkerInfo> lineMarkers, Project project) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.setLineMarkers must not be null");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModel markup = document.getMarkupModel(project);
        markup.putUserData(MARKERS_IN_EDITOR_DOCUMENT_KEY, lineMarkers);
    }

    public synchronized void setLastIntentionHint(Project project, PsiFile file, Editor editor, ShowIntentionsPass.IntentionsInfo intentions, boolean hasToRecreate) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.hideLastIntentionHint();
        IntentionHintComponent hintComponent = IntentionHintComponent.showIntentionHint(project, file, editor, intentions, false);
        if (hasToRecreate) {
            hintComponent.recreate();
        }
        this.myLastIntentionHint = hintComponent;
    }

    public synchronized void hideLastIntentionHint() {
        if (this.myLastIntentionHint != null && this.myLastIntentionHint.isVisible()) {
            this.myLastIntentionHint.hide();
        }
    }

    public synchronized IntentionHintComponent getLastIntentionHint() {
        return this.myLastIntentionHint;
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        Element disableHintsElement = new Element(DISABLE_HINTS_TAG);
        parentNode.addContent(disableHintsElement);
        ArrayList<String> array = new ArrayList<String>();
        for (VirtualFile file : this.myDisabledHintsFiles) {
            if (!file.isValid()) continue;
            array.add(file.getUrl());
        }
        Collections.sort(array);
        for (String url : array) {
            Element fileElement = new Element(FILE_TAG);
            fileElement.setAttribute(URL_ATT, url);
            disableHintsElement.addContent(fileElement);
        }
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        this.myDisabledHintsFiles.clear();
        Element element = parentNode.getChild(DISABLE_HINTS_TAG);
        if (element != null) {
            for (Object o : element.getChildren(FILE_TAG)) {
                VirtualFile file;
                Element e = (Element)o;
                String url = e.getAttributeValue(URL_ATT);
                if (url == null || (file = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
                this.myDisabledHintsFiles.add(file);
            }
        }
    }

    private Runnable createUpdateRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DaemonProgressIndicator progress;
                if (!DaemonCodeAnalyzerImpl.this.myUpdateByTimerEnabled) {
                    return;
                }
                if (DaemonCodeAnalyzerImpl.this.myDisposed || DaemonCodeAnalyzerImpl.this.myProject.isDisposed()) {
                    return;
                }
                Collection<FileEditor> activeEditors = DaemonCodeAnalyzerImpl.this.myDaemonListeners.getSelectedEditors();
                if (activeEditors.isEmpty()) {
                    return;
                }
                THashMap passes = new THashMap(activeEditors.size());
                for (FileEditor fileEditor : activeEditors) {
                    BackgroundEditorHighlighter highlighter = fileEditor.getBackgroundHighlighter();
                    if (highlighter == null) continue;
                    HighlightingPass[] highlightingPasses = highlighter.createPassesForEditor();
                    passes.put(fileEditor, highlightingPasses);
                }
                DaemonCodeAnalyzerImpl.this.cancelUpdateProgress(true, "Cancel by alarm");
                DaemonCodeAnalyzerImpl.this.myAlarm.cancelAllRequests();
                DaemonCodeAnalyzerImpl daemonCodeAnalyzerImpl = DaemonCodeAnalyzerImpl.this;
                synchronized (daemonCodeAnalyzerImpl) {
                    progress = DaemonCodeAnalyzerImpl.recreateProgress();
                    DaemonCodeAnalyzerImpl.this.myUpdateProgress = progress;
                }
                DaemonCodeAnalyzerImpl.this.myPassExecutorService.submitPasses((Map<FileEditor, HighlightingPass[]>)passes, progress, 100);
            }
        };
    }

    public boolean canChangeFileSilently(PsiFileSystemItem file) {
        return this.myDaemonListeners.canChangeFileSilently(file);
    }

    public void autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.autoImportReferenceAtCursor must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.autoImportReferenceAtCursor must not be null");
        }
        for (ReferenceImporter importer : (ReferenceImporter[])Extensions.getExtensions(ReferenceImporter.EP_NAME)) {
            if (importer.autoImportReferenceAtCursor(editor, file)) break;
        }
    }

    @NotNull
    static List<HighlightInfo> getHighlightsToRemove(MarkupModel markup) {
        List infos = (List)markup.getUserData(HIGHLIGHTS_TO_REMOVE_KEY);
        List list = infos == null ? Collections.emptyList() : infos;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.getHighlightsToRemove must not return null");
        }
        return list;
    }

    @NotNull
    public static List<HighlightInfo> getFileLevelHighlights(Project project, PsiFile file) {
        List<HighlightInfo> list = UpdateHighlightersUtil.getFileLeveleHighlights(project, file);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerImpl.getFileLevelHighlights must not return null");
        }
        return list;
    }

    public void clearPasses() {
        this.myPassExecutorService.cancelAll(true);
    }
}

