/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeverityRegistrar
implements JDOMExternalizable,
Comparator<HighlightSeverity> {
    @NonNls
    private static final String INFO = "info";
    private final Map<String, SeverityBasedTextAttributes> ourMap = new THashMap();
    private final Map<String, Color> ourRendererColors = new THashMap();
    @NonNls
    private static final String COLOR = "color";
    private final JDOMExternalizableStringList myOrder = new JDOMExternalizableStringList();
    private JDOMExternalizableStringList myReadOrder;
    private static final Map<String, HighlightInfoType> STANDART_SEVERITIES = new HashMap<String, HighlightInfoType>();

    public static SeverityRegistrar getInstance() {
        return InspectionProfileManager.getInstance().getSeverityRegistrar();
    }

    public static SeverityRegistrar getInstance(@Nullable Project project) {
        return project != null ? InspectionProjectProfileManager.getInstance(project).getSeverityRegistrar() : SeverityRegistrar.getInstance();
    }

    public void registerSeverity(SeverityBasedTextAttributes info, Color renderColor) {
        HighlightSeverity severity = info.getType().getSeverity(null);
        this.ourMap.put(severity.toString(), info);
        this.ourRendererColors.put(severity.toString(), renderColor);
        this.myOrder.clear();
        HighlightDisplayLevel.registerSeverity((HighlightSeverity)severity, (Color)renderColor);
    }

    public Collection<SeverityBasedTextAttributes> getRegisteredHighlightingInfoTypes() {
        ArrayList<SeverityBasedTextAttributes> collection = new ArrayList<SeverityBasedTextAttributes>(this.ourMap.values());
        for (HighlightInfoType type : STANDART_SEVERITIES.values()) {
            collection.add(this.getSeverityBasedTextAttributes(type));
        }
        return collection;
    }

    private SeverityBasedTextAttributes getSeverityBasedTextAttributes(HighlightInfoType type) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes textAttributes = scheme.getAttributes(type.getAttributesKey());
        if (textAttributes != null) {
            return new SeverityBasedTextAttributes(textAttributes, (HighlightInfoType.HighlightInfoTypeImpl)type);
        }
        return new SeverityBasedTextAttributes(this.getTextAttributesBySeverity(type.getSeverity(null)), (HighlightInfoType.HighlightInfoTypeImpl)type);
    }

    public SeverityBasedTextAttributes unregisterSeverity(HighlightSeverity severity) {
        return this.ourMap.remove(severity.toString());
    }

    public HighlightInfoType.HighlightInfoTypeImpl getHighlightInfoTypeBySeverity(HighlightSeverity severity) {
        HighlightInfoType infoType = STANDART_SEVERITIES.get(severity.toString());
        if (infoType != null) {
            return (HighlightInfoType.HighlightInfoTypeImpl)infoType;
        }
        if (severity == HighlightSeverity.INFORMATION) {
            return (HighlightInfoType.HighlightInfoTypeImpl)HighlightInfoType.INFORMATION;
        }
        SeverityBasedTextAttributes type = this.ourMap.get(severity.toString());
        return (HighlightInfoType.HighlightInfoTypeImpl)(type != null ? type.getType() : HighlightInfoType.WARNING);
    }

    @Nullable
    public TextAttributes getTextAttributesBySeverity(HighlightSeverity severity) {
        SeverityBasedTextAttributes infoType = this.ourMap.get(severity.toString());
        if (infoType != null) {
            return infoType.getAttributes();
        }
        return null;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.ourMap.clear();
        this.ourRendererColors.clear();
        List children = element.getChildren(INFO);
        if (children != null) {
            for (Object child : children) {
                Element infoElement = (Element)child;
                SeverityBasedTextAttributes highlightInfo = new SeverityBasedTextAttributes();
                highlightInfo.readExternal(infoElement);
                Color color = null;
                String colorStr = infoElement.getAttributeValue(COLOR);
                if (colorStr != null) {
                    color = new Color(Integer.parseInt(colorStr, 16));
                }
                this.registerSeverity(highlightInfo, color);
            }
        }
        this.myOrder.clear();
        this.myOrder.readExternal(element);
        this.myReadOrder = new JDOMExternalizableStringList();
        this.myReadOrder.addAll((Collection)this.myOrder);
        List<String> knownSeverities = this.createCurrentSeverities();
        this.myOrder.retainAll(knownSeverities);
        if (this.myOrder.isEmpty()) {
            this.myOrder.addAll(this.getDefaultOrder());
        }
        block1: for (int i = 0; i < knownSeverities.size(); ++i) {
            String stdSeverity = knownSeverities.get(i);
            if (this.myOrder.contains((Object)stdSeverity)) continue;
            for (int oIdx = 0; oIdx < this.myOrder.size(); ++oIdx) {
                String orderSeverity = (String)this.myOrder.get(oIdx);
                HighlightInfoType type = STANDART_SEVERITIES.get(orderSeverity);
                if (type == null || knownSeverities.indexOf(type.getSeverity(null).toString()) <= i) continue;
                this.myOrder.add(oIdx, (Object)stdSeverity);
                this.myReadOrder = null;
                continue block1;
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (String severity : this.getOrder()) {
            Element info = new Element(INFO);
            SeverityBasedTextAttributes infoType = this.ourMap.get(severity);
            if (infoType == null) continue;
            infoType.writeExternal(info);
            Color color = this.ourRendererColors.get(severity);
            if (color != null) {
                info.setAttribute(COLOR, Integer.toString(color.getRGB() & 0xFFFFFF, 16));
            }
            element.addContent(info);
        }
        if (this.myReadOrder != null && !this.myReadOrder.isEmpty()) {
            this.myReadOrder.writeExternal(element);
        } else if (!((Object)this.getDefaultOrder()).equals(this.getOrder())) {
            this.getOrder().writeExternal(element);
        }
    }

    public int getSeveritiesCount() {
        return this.createCurrentSeverities().size();
    }

    public HighlightSeverity getSeverityByIndex(int i) {
        return this.getSeverity((String)this.getOrder().get(i));
    }

    public HighlightSeverity getSeverity(String name) {
        HighlightInfoType type = STANDART_SEVERITIES.get(name);
        if (type != null) {
            return type.getSeverity(null);
        }
        SeverityBasedTextAttributes attributes = this.ourMap.get(name);
        if (attributes != null) {
            return attributes.getSeverity();
        }
        return null;
    }

    private List<String> createCurrentSeverities() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(STANDART_SEVERITIES.keySet());
        list.addAll(this.ourMap.keySet());
        ContainerUtil.sort(list);
        return list;
    }

    public Icon getRendererIconByIndex(int i) {
        HighlightSeverity severity = this.getSeverityByIndex(i);
        HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
        if (level != null) {
            return level.getIcon();
        }
        return HighlightDisplayLevel.createIconByMask((Color)this.ourRendererColors.get(severity.toString()));
    }

    public boolean isSeverityValid(String severity) {
        return this.createCurrentSeverities().contains(severity);
    }

    @Override
    public int compare(HighlightSeverity s1, HighlightSeverity s2) {
        return this.getOrder().indexOf((Object)s1.myName) - this.getOrder().indexOf((Object)s2.myName);
    }

    private JDOMExternalizableStringList getOrder() {
        if (this.myOrder.isEmpty()) {
            this.myOrder.addAll(this.getDefaultOrder());
        }
        return this.myOrder;
    }

    private List<String> getDefaultOrder() {
        ArrayList<HighlightSeverity> order = new ArrayList<HighlightSeverity>();
        for (HighlightInfoType type : STANDART_SEVERITIES.values()) {
            order.add(type.getSeverity(null));
        }
        for (SeverityBasedTextAttributes attributes : this.ourMap.values()) {
            order.add(attributes.getSeverity());
        }
        ContainerUtil.sort(order);
        ArrayList<String> result = new ArrayList<String>();
        for (HighlightSeverity severity : order) {
            result.add(severity.toString());
        }
        return result;
    }

    public void setOrder(List<String> order) {
        this.myOrder.clear();
        this.myOrder.addAll(order);
        this.myReadOrder = null;
    }

    public int getSeverityIdx(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/SeverityRegistrar.getSeverityIdx must not be null");
        }
        return this.getOrder().indexOf((Object)severity.toString());
    }

    public boolean isDefaultSeverity(HighlightSeverity severity) {
        return STANDART_SEVERITIES.containsKey(severity.myName);
    }

    public static boolean skipSeverity(HighlightSeverity minSeverity) {
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            if (provider.isGotoBySeverityEnabled(minSeverity)) continue;
            return true;
        }
        return minSeverity == HighlightSeverity.INFORMATION;
    }

    static {
        STANDART_SEVERITIES.put(HighlightSeverity.ERROR.toString(), HighlightInfoType.ERROR);
        STANDART_SEVERITIES.put(HighlightSeverity.WARNING.toString(), HighlightInfoType.WARNING);
        STANDART_SEVERITIES.put(HighlightSeverity.INFO.toString(), HighlightInfoType.INFO);
        STANDART_SEVERITIES.put(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING.toString(), HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        for (SeveritiesProvider provider : (SeveritiesProvider[])Extensions.getExtensions(SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType highlightInfoType : provider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity highlightSeverity = highlightInfoType.getSeverity(null);
                STANDART_SEVERITIES.put(highlightSeverity.toString(), highlightInfoType);
                TextAttributesKey attributesKey = highlightInfoType.getAttributesKey();
                TextAttributes textAttributes = scheme.getAttributes(attributesKey);
                if (textAttributes == null) {
                    textAttributes = attributesKey.getDefaultAttributes();
                }
                HighlightDisplayLevel.registerSeverity((HighlightSeverity)highlightSeverity, (Color)provider.getTrafficRendererColor(textAttributes));
            }
        }
    }

    public static class SeverityBasedTextAttributes
    implements JDOMExternalizable {
        private final TextAttributes myAttributes;
        private final HighlightInfoType.HighlightInfoTypeImpl myType;

        public SeverityBasedTextAttributes() {
            this.myAttributes = new TextAttributes();
            this.myType = new HighlightInfoType.HighlightInfoTypeImpl();
        }

        public SeverityBasedTextAttributes(TextAttributes attributes, HighlightInfoType.HighlightInfoTypeImpl type) {
            this.myAttributes = attributes;
            this.myType = type;
        }

        public TextAttributes getAttributes() {
            return this.myAttributes;
        }

        public HighlightInfoType.HighlightInfoTypeImpl getType() {
            return this.myType;
        }

        public void readExternal(Element element) throws InvalidDataException {
            this.myAttributes.readExternal(element);
            this.myType.readExternal(element);
        }

        public void writeExternal(Element element) throws WriteExternalException {
            this.myAttributes.writeExternal(element);
            this.myType.writeExternal(element);
        }

        public HighlightSeverity getSeverity() {
            return this.myType.getSeverity(null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SeverityBasedTextAttributes that = (SeverityBasedTextAttributes)o;
            if (this.myAttributes != null ? !this.myAttributes.equals((Object)that.myAttributes) : that.myAttributes != null) {
                return false;
            }
            return !(this.myType != null ? !this.myType.equals(that.myType) : that.myType != null);
        }

        public int hashCode() {
            int result = this.myAttributes != null ? this.myAttributes.hashCode() : 0;
            result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
            return result;
        }
    }
}

