/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorHighlightingPassRegistrarImpl
extends TextEditorHighlightingPassRegistrarEx {
    private final TIntObjectHashMap<PassConfig> myRegisteredPassFactories = new TIntObjectHashMap();
    private final List<DirtyScopeTrackingHighlightingPassFactory> myDirtyScopeTrackingFactories = new ArrayList<DirtyScopeTrackingHighlightingPassFactory>();
    private int nextAvailableId = 12;
    private boolean checkedForCycles;
    private final Project myProject;

    public TextEditorHighlightingPassRegistrarImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void registerTextEditorHighlightingPass(TextEditorHighlightingPassFactory factory, int anchor, int anchorPass) {
        TextEditorHighlightingPassRegistrar.Anchor anc = TextEditorHighlightingPassRegistrar.Anchor.FIRST;
        switch (anchor) {
            case 0: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.FIRST;
                break;
            }
            case 1: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.LAST;
                break;
            }
            case 3: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.BEFORE;
                break;
            }
            case 2: {
                anc = TextEditorHighlightingPassRegistrar.Anchor.AFTER;
            }
        }
        this.registerTextEditorHighlightingPass(factory, anc, anchorPass, true, true);
    }

    @Override
    public synchronized int registerTextEditorHighlightingPass(@NotNull TextEditorHighlightingPassFactory factory, @Nullable int[] runAfterCompletionOf, @Nullable int[] runAfterOfStartingOf, boolean runIntentionsPassAfter, int forcedPassId) {
        int n;
        if (factory == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl.registerTextEditorHighlightingPass must not be null");
        }
        assert (!this.checkedForCycles);
        PassConfig info = new PassConfig(factory, runAfterCompletionOf == null || runAfterCompletionOf.length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : runAfterCompletionOf, runAfterOfStartingOf == null || runAfterOfStartingOf.length == 0 ? ArrayUtil.EMPTY_INT_ARRAY : runAfterOfStartingOf);
        if (forcedPassId == -1) {
            int n2 = this.nextAvailableId;
            n = n2;
            this.nextAvailableId = n2 + 1;
        } else {
            n = forcedPassId;
        }
        int passId = n;
        PassConfig registered = (PassConfig)this.myRegisteredPassFactories.get(passId);
        assert (registered == null) : "Pass id " + passId + " has already been registered: " + PassConfig.access$100(registered);
        this.myRegisteredPassFactories.put(passId, (Object)info);
        if (factory instanceof DirtyScopeTrackingHighlightingPassFactory) {
            this.myDirtyScopeTrackingFactories.add((DirtyScopeTrackingHighlightingPassFactory)factory);
        }
        return passId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiatePasses(final @NotNull PsiFile psiFile, final @NotNull Editor editor, final @NotNull int[] passesToIgnore) {
        if (psiFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl.instantiatePasses must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl.instantiatePasses must not be null");
        }
        if (passesToIgnore == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl.instantiatePasses must not be null");
        }
        TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = this;
        synchronized (textEditorHighlightingPassRegistrarImpl) {
            if (!this.checkedForCycles) {
                this.checkedForCycles = true;
                this.checkForCycles();
            }
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        PsiFile fileFromDoc = documentManager.getPsiFile(editor.getDocument());
        if (!(fileFromDoc instanceof PsiCompiledElement)) {
            assert (fileFromDoc == psiFile) : "Files are different: " + psiFile + ";" + fileFromDoc;
            Document documentFromFile = documentManager.getDocument(psiFile);
            assert (documentFromFile == editor.getDocument()) : "Documents are different: " + editor.getDocument() + ";" + documentFromFile;
        }
        final TIntObjectHashMap id2Pass = new TIntObjectHashMap();
        final TIntArrayList passesRefusedToCreate = new TIntArrayList();
        this.myRegisteredPassFactories.forEachKey(new TIntProcedure(){

            public boolean execute(int passId) {
                if (ArrayUtil.find((int[])passesToIgnore, (int)passId) != -1) {
                    return true;
                }
                PassConfig passConfig = (PassConfig)TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.get(passId);
                TextEditorHighlightingPassFactory factory = passConfig.passFactory;
                TextEditorHighlightingPass pass = factory.createHighlightingPass(psiFile, editor);
                if (pass == null) {
                    passesRefusedToCreate.add(passId);
                } else {
                    TIntArrayList ids = new TIntArrayList(passConfig.completionPredecessorIds.length);
                    for (int id : passConfig.completionPredecessorIds) {
                        if (!TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.containsKey(id)) continue;
                        ids.add(id);
                    }
                    pass.setCompletionPredecessorIds(ids.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : ids.toNativeArray());
                    ids = new TIntArrayList(passConfig.startingPredecessorIds.length);
                    for (int id : passConfig.startingPredecessorIds) {
                        if (!TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.containsKey(id)) continue;
                        ids.add(id);
                    }
                    pass.setStartingPredecessorIds(ids.isEmpty() ? ArrayUtil.EMPTY_INT_ARRAY : ids.toNativeArray());
                    pass.setId(passId);
                    id2Pass.put(passId, (Object)pass);
                }
                return true;
            }
        });
        final FileStatusMap statusMap = ((DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject)).getFileStatusMap();
        passesRefusedToCreate.forEach(new TIntProcedure(){

            public boolean execute(int passId) {
                statusMap.markFileUpToDate(editor.getDocument(), psiFile, passId);
                return true;
            }
        });
        List<TextEditorHighlightingPass> list = TextEditorHighlightingPassRegistrarImpl.topoSort((TIntObjectHashMap<TextEditorHighlightingPass>)id2Pass);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl.instantiatePasses must not return null");
        }
        return list;
    }

    private static List<TextEditorHighlightingPass> topoSort(final TIntObjectHashMap<TextEditorHighlightingPass> id2Pass) {
        THashSet topPasses = new THashSet(id2Pass.size());
        id2Pass.forEachValue((TObjectProcedure)new TObjectProcedure<TextEditorHighlightingPass>((Set)topPasses){
            final /* synthetic */ Set val$topPasses;
            {
                this.val$topPasses = set;
            }

            public boolean execute(TextEditorHighlightingPass object) {
                this.val$topPasses.add(object);
                return true;
            }
        });
        id2Pass.forEachValue((TObjectProcedure)new TObjectProcedure<TextEditorHighlightingPass>((Set)topPasses){
            final /* synthetic */ Set val$topPasses;
            {
                this.val$topPasses = set;
            }

            public boolean execute(TextEditorHighlightingPass pass) {
                TextEditorHighlightingPass pred;
                for (int id : pass.getCompletionPredecessorIds()) {
                    pred = (TextEditorHighlightingPass)id2Pass.get(id);
                    if (pred == null) continue;
                    this.val$topPasses.remove(pred);
                }
                for (int id : pass.getStartingPredecessorIds()) {
                    pred = (TextEditorHighlightingPass)id2Pass.get(id);
                    if (pred == null) continue;
                    this.val$topPasses.remove(pred);
                }
                return true;
            }
        });
        ArrayList<TextEditorHighlightingPass> result = new ArrayList<TextEditorHighlightingPass>();
        for (TextEditorHighlightingPass topPass : topPasses) {
            TextEditorHighlightingPassRegistrarImpl.layout(topPass, result, id2Pass);
        }
        return result;
    }

    private static void layout(@NotNull TextEditorHighlightingPass pass, @NotNull List<TextEditorHighlightingPass> result, @NotNull TIntObjectHashMap<TextEditorHighlightingPass> id2Pass) {
        TextEditorHighlightingPass pred;
        if (pass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl.layout must not be null");
        }
        if (result == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl.layout must not be null");
        }
        if (id2Pass == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl.layout must not be null");
        }
        if (result.contains(pass)) {
            return;
        }
        for (int id : pass.getCompletionPredecessorIds()) {
            pred = (TextEditorHighlightingPass)id2Pass.get(id);
            if (pred == null) continue;
            TextEditorHighlightingPassRegistrarImpl.layout(pred, result, id2Pass);
        }
        for (int id : pass.getStartingPredecessorIds()) {
            pred = (TextEditorHighlightingPass)id2Pass.get(id);
            if (pred == null) continue;
            TextEditorHighlightingPassRegistrarImpl.layout(pred, result, id2Pass);
        }
        result.add(pass);
    }

    private void checkForCycles() {
        final TIntObjectHashMap transitivePredecessors = new TIntObjectHashMap();
        this.myRegisteredPassFactories.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<PassConfig>(){

            public boolean execute(int passId, PassConfig config) {
                TIntHashSet allPredecessors = new TIntHashSet(config.completionPredecessorIds);
                allPredecessors.addAll(config.startingPredecessorIds);
                transitivePredecessors.put(passId, (Object)allPredecessors);
                allPredecessors.forEach(new TIntProcedure(){

                    public boolean execute(int predecessorId) {
                        PassConfig predecessor = (PassConfig)TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.get(predecessorId);
                        if (predecessor == null) {
                            return true;
                        }
                        TIntHashSet transitives = (TIntHashSet)transitivePredecessors.get(predecessorId);
                        if (transitives == null) {
                            transitives = new TIntHashSet();
                            transitivePredecessors.put(predecessorId, (Object)transitives);
                        }
                        transitives.addAll(predecessor.completionPredecessorIds);
                        transitives.addAll(predecessor.startingPredecessorIds);
                        return true;
                    }
                });
                return true;
            }
        });
        transitivePredecessors.forEachKey(new TIntProcedure(){

            public boolean execute(int passId) {
                if (((TIntHashSet)transitivePredecessors.get(passId)).contains(passId)) {
                    throw new IllegalArgumentException("There is a cycle introduced involving pass " + ((PassConfig)TextEditorHighlightingPassRegistrarImpl.this.myRegisteredPassFactories.get(passId)).passFactory);
                }
                return true;
            }
        });
    }

    public List<DirtyScopeTrackingHighlightingPassFactory> getDirtyScopeTrackingFactories() {
        return this.myDirtyScopeTrackingFactories;
    }

    private static class PassConfig {
        private final TextEditorHighlightingPassFactory passFactory;
        private final int[] startingPredecessorIds;
        private final int[] completionPredecessorIds;

        private PassConfig(@NotNull TextEditorHighlightingPassFactory passFactory, @NotNull int[] completionPredecessorIds, @NotNull int[] startingPredecessorIds) {
            if (passFactory == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig.<init> must not be null");
            }
            if (completionPredecessorIds == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig.<init> must not be null");
            }
            if (startingPredecessorIds == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig.<init> must not be null");
            }
            this.completionPredecessorIds = completionPredecessorIds;
            this.startingPredecessorIds = startingPredecessorIds;
            this.passFactory = passFactory;
        }
    }
}

