/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InsertRequiredAttributeFix
implements IntentionAction,
LocalQuickFix {
    private final XmlTag myTag;
    private final String myAttrName;
    private final String[] myValues;
    @NonNls
    private static final String NAME_TEMPLATE_VARIABLE = "name";

    public InsertRequiredAttributeFix(XmlTag tag, String attrName, String[] values) {
        this.myTag = tag;
        this.myAttrName = attrName;
        this.myValues = values;
    }

    @NotNull
    public String getText() {
        String string = XmlErrorMessages.message("insert.required.attribute.quickfix.text", this.myAttrName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlErrorMessages.message("insert.required.attribute.quickfix.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix.applyFix must not be null");
        }
        this.invoke(project, null, this.myTag.getContainingFile());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix.isAvailable must not be null");
        }
        return this.myTag.isValid();
    }

    public void invoke(final @NotNull Project project, final Editor editor, PsiFile file) {
        boolean anchorIsEmptyTag;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/InsertRequiredAttributeFix.invoke must not be null");
        }
        if (!CodeInsightUtilBase.prepareFileForWrite(file)) {
            return;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree((PsiElement)this.myTag);
        XmlElementDescriptor descriptor = this.myTag.getDescriptor();
        if (descriptor == null) {
            return;
        }
        XmlAttributeDescriptor attrDescriptor = descriptor.getAttributeDescriptor(this.myAttrName, this.myTag);
        boolean indirectSyntax = XmlExtension.getExtension((PsiFile)((XmlFile)this.myTag.getContainingFile())).isIndirectSyntax(attrDescriptor);
        PsiElement anchor = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.EMPTY_TAG_END_FINDER.findChild(treeElement));
        boolean bl = anchorIsEmptyTag = anchor != null;
        if (anchor == null) {
            anchor = SourceTreeToPsiMap.treeElementToPsi(XmlChildRole.START_TAG_END_FINDER.findChild(treeElement));
        }
        if (anchor == null) {
            return;
        }
        final Template template = TemplateManager.getInstance(project).createTemplate("", "");
        if (indirectSyntax) {
            if (anchorIsEmptyTag) {
                template.addTextSegment(">");
            }
            template.addTextSegment("<jsp:attribute name=\"" + this.myAttrName + "\">");
        } else {
            template.addTextSegment(" " + this.myAttrName + "=\"");
        }
        Expression expression = new Expression(){
            TextResult result = new TextResult("");

            public Result calculateResult(ExpressionContext context) {
                return this.result;
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return null;
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                LookupElement[] items = new LookupElement[InsertRequiredAttributeFix.this.myValues == null ? 0 : InsertRequiredAttributeFix.this.myValues.length];
                if (InsertRequiredAttributeFix.this.myValues != null) {
                    for (int i = 0; i < items.length; ++i) {
                        items[i] = LookupElementBuilder.create((String)InsertRequiredAttributeFix.this.myValues[i]);
                    }
                }
                return items;
            }
        };
        template.addVariable(NAME_TEMPLATE_VARIABLE, expression, expression, true);
        if (indirectSyntax) {
            template.addTextSegment("</jsp:attribute>");
            template.addEndVariable();
            if (anchorIsEmptyTag) {
                template.addTextSegment("</" + this.myTag.getName() + ">");
            }
        } else {
            template.addTextSegment("\"");
        }
        final PsiElement anchor1 = anchor;
        final boolean indirectSyntax1 = indirectSyntax;
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        int textOffset = anchor1.getTextOffset();
                        if (!anchorIsEmptyTag && indirectSyntax1) {
                            ++textOffset;
                        }
                        editor.getCaretModel().moveToOffset(textOffset);
                        if (anchorIsEmptyTag && indirectSyntax1) {
                            editor.getDocument().deleteString(textOffset, textOffset + 2);
                        }
                        TemplateManager.getInstance(project).startTemplate(editor, template, null);
                    }
                });
            }
        };
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            Runnable commandRunnable = new Runnable(){

                @Override
                public void run() {
                    CommandProcessor.getInstance().executeCommand(project, runnable, InsertRequiredAttributeFix.this.getText(), (Object)InsertRequiredAttributeFix.this.getFamilyName());
                }
            };
            ApplicationManager.getApplication().invokeLater(commandRunnable);
        } else {
            runnable.run();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

