/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.CreateNSDeclarationIntentionFix;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlUnboundNsPrefixInspection
extends XmlSuppressableInspectionTool {
    @NonNls
    private static final String XML = "xml";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/XmlUnboundNsPrefixInspection.buildVisitor must not be null");
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){
            private Boolean isXml;

            private boolean isXmlFile(XmlElement element) {
                if (this.isXml == null) {
                    PsiFile file = element.getContainingFile();
                    this.isXml = file instanceof XmlFile && !InjectedLanguageManager.getInstance((Project)element.getProject()).isInjectedFragment(file);
                }
                return this.isXml;
            }

            public void visitXmlToken(XmlToken token) {
                if (this.isXmlFile((XmlElement)token) && token.getTokenType() == XmlTokenType.XML_NAME) {
                    PsiElement parent;
                    PsiElement element = token.getPrevSibling();
                    while (element instanceof PsiWhiteSpace) {
                        element = element.getPrevSibling();
                    }
                    if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_START_TAG_START && (parent = element.getParent()) instanceof XmlTag && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                        XmlTag tag = (XmlTag)parent;
                        XmlUnboundNsPrefixInspection.checkUnboundNamespacePrefix((XmlElement)tag, tag, tag.getNamespacePrefix(), token, holder, isOnTheFly);
                    }
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (!this.isXmlFile((XmlElement)attribute)) {
                    return;
                }
                String namespace = attribute.getNamespace();
                if (attribute.isNamespaceDeclaration() || "http://www.w3.org/2001/XMLSchema-instance".equals(namespace)) {
                    return;
                }
                XmlTag tag = attribute.getParent();
                XmlElementDescriptor elementDescriptor = tag.getDescriptor();
                if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                    return;
                }
                String name = attribute.getName();
                XmlUnboundNsPrefixInspection.checkUnboundNamespacePrefix((XmlElement)attribute, tag, XmlUtil.findPrefixByQualifiedName(name), null, holder, isOnTheFly);
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlUnboundNsPrefixInspection.buildVisitor must not return null");
        }
        return xmlElementVisitor;
    }

    private static void checkUnboundNamespacePrefix(XmlElement element, XmlTag context, String namespacePrefix, XmlToken token, ProblemsHolder holder, boolean isOnTheFly) {
        ProblemHighlightType highlightType;
        String localizedMessage;
        if (namespacePrefix.length() == 0 && (!(element instanceof XmlTag) || !(element.getParent() instanceof XmlDocument)) || XML.equals(namespacePrefix)) {
            return;
        }
        String namespaceByPrefix = context.getNamespaceByPrefix(namespacePrefix);
        if (namespaceByPrefix.length() != 0) {
            return;
        }
        XmlFile containingFile = (XmlFile)context.getContainingFile();
        if (!HighlightLevelUtil.shouldInspect((PsiElement)containingFile)) {
            return;
        }
        XmlExtension extension = XmlExtension.getExtension((PsiFile)containingFile);
        if (extension.isPrefixDeclared(context, namespacePrefix)) {
            return;
        }
        String string = localizedMessage = isOnTheFly ? XmlErrorMessages.message("unbound.namespace", namespacePrefix) : XmlErrorMessages.message("unbound.namespace.no.param", new Object[0]);
        if (namespacePrefix.length() == 0) {
            XmlTag tag = (XmlTag)element;
            if (!"http://java.sun.com/JSP/Page".equals(tag.getNamespace())) {
                XmlUnboundNsPrefixInspection.reportTagProblem((XmlElement)tag, localizedMessage, null, ProblemHighlightType.INFORMATION, isOnTheFly ? new CreateNSDeclarationIntentionFix((PsiElement)context, namespacePrefix, token) : null, holder);
            }
            return;
        }
        int prefixLength = namespacePrefix.length();
        TextRange range = new TextRange(0, prefixLength);
        HighlightInfoType infoType = extension.getHighlightInfoType(containingFile);
        ProblemHighlightType problemHighlightType = highlightType = infoType == HighlightInfoType.ERROR ? ProblemHighlightType.ERROR : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        if (element instanceof XmlTag) {
            CreateNSDeclarationIntentionFix fix = isOnTheFly ? new CreateNSDeclarationIntentionFix((PsiElement)context, namespacePrefix, token) : null;
            XmlUnboundNsPrefixInspection.reportTagProblem(element, localizedMessage, range, highlightType, fix, holder);
        } else {
            holder.registerProblem((PsiElement)element, localizedMessage, highlightType, range, new LocalQuickFix[0]);
        }
    }

    private static void reportTagProblem(XmlElement element, String localizedMessage, TextRange range, ProblemHighlightType highlightType, CreateNSDeclarationIntentionFix fix, ProblemsHolder holder) {
        XmlToken nameToken = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)element));
        if (nameToken != null) {
            holder.registerProblem((PsiElement)nameToken, localizedMessage, highlightType, range, new LocalQuickFix[]{fix});
        }
        if ((nameToken = XmlTagUtil.getEndTagNameElement((XmlTag)((XmlTag)element))) != null) {
            holder.registerProblem((PsiElement)nameToken, localizedMessage, highlightType, range, new LocalQuickFix[]{fix});
        }
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlUnboundNsPrefixInspection.getDefaultLevel must not return null");
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = XmlBundle.message((String)"xml.inspections.group.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlUnboundNsPrefixInspection.getGroupDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"xml.inspections.unbound.prefix", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlUnboundNsPrefixInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("XmlUnboundNsPrefix" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/impl/analysis/XmlUnboundNsPrefixInspection.getShortName must not return null");
        }
        return "XmlUnboundNsPrefix";
    }
}

