/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;

public class CreateInnerClassFromNewFix
extends CreateClassFromNewFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromNewFix");

    public CreateInnerClassFromNewFix(PsiNewExpression expr) {
        super(expr);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.inner.class.from.usage.text", StringUtil.capitalize((String)CreateClassKind.CLASS.getDescription()), varName);
    }

    @Override
    protected boolean isAllowOuterTargetClass() {
        return true;
    }

    @Override
    protected void invokeImpl(final PsiClass targetClass) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    PsiNewExpression newExpression = CreateInnerClassFromNewFix.this.getNewExpression();
                    PsiJavaCodeReferenceElement ref = newExpression.getClassOrAnonymousClassReference();
                    assert (ref != null);
                    String refName = ref.getReferenceName();
                    LOG.assertTrue(refName != null);
                    PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)newExpression.getProject()).getElementFactory();
                    PsiClass created = elementFactory.createClass(refName);
                    PsiModifierList modifierList = created.getModifierList();
                    LOG.assertTrue(modifierList != null);
                    modifierList.setModifierProperty("private", true);
                    if (PsiUtil.getEnclosingStaticElement((PsiElement)newExpression, (PsiClass)targetClass) != null) {
                        modifierList.setModifierProperty("static", true);
                    }
                    created = (PsiClass)targetClass.add((PsiElement)created);
                    CreateClassFromNewFix.setupClassFromNewExpression(created, newExpression);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }
}

